/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.core.protocol.MessageFuture;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.mockserver.processor.MockRemotingProcessor;

public class MockOnRespProcessor
extends MockRemotingProcessor {
    private ConcurrentMap<Integer, MessageFuture> futures;

    public MockOnRespProcessor(RemotingServer remotingServer, TransactionMessageHandler handler, ConcurrentMap<Integer, MessageFuture> futures) {
        super(remotingServer, handler);
        this.futures = futures;
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        super.process(ctx, rpcMessage);
        MessageFuture messageFuture = (MessageFuture)this.futures.remove(rpcMessage.getId());
        if (messageFuture != null) {
            messageFuture.setResultMessage(rpcMessage.getBody());
        }
    }
}

