/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.MergeResultMessage;
import org.apache.seata.core.protocol.MergedWarpMessage;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.mockserver.processor.MockRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockOnReqProcessor
extends MockRemotingProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MockOnReqProcessor.class);

    public MockOnReqProcessor(RemotingServer remotingServer, TransactionMessageHandler handler) {
        super(remotingServer, handler);
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        super.process(ctx, rpcMessage);
        Object message = rpcMessage.getBody();
        RpcContext rpcContext = ChannelManager.getContextFromIdentified((Channel)ctx.channel());
        if (message instanceof MergedWarpMessage) {
            MergedWarpMessage mmsg = (MergedWarpMessage)message;
            MergeResultMessage resultMessage = new MergeResultMessage();
            ArrayList<AbstractResultMessage> resList = new ArrayList<AbstractResultMessage>();
            for (int i = 0; i < mmsg.msgs.size(); ++i) {
                AbstractMessage msg = (AbstractMessage)mmsg.msgs.get(i);
                resList.add(this.handler.onRequest(msg, rpcContext));
            }
            AbstractResultMessage[] resultMsgs = (AbstractResultMessage[])Arrays.copyOf(resList.toArray(), resList.size(), AbstractResultMessage[].class);
            resultMessage.setMsgs(resultMsgs);
            this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), (Object)resultMessage);
            LOGGER.info("sendAsyncResponse: {}", (Object)resultMessage);
        } else {
            AbstractMessage msg = (AbstractMessage)message;
            AbstractResultMessage result = this.handler.onRequest(msg, rpcContext);
            this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), (Object)result);
            LOGGER.info("sendAsyncResponse: {}", (Object)result);
        }
    }
}

