/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver.call;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.protocol.transaction.AbstractBranchEndRequest;
import org.apache.seata.core.protocol.transaction.BranchCommitRequest;
import org.apache.seata.core.protocol.transaction.BranchCommitResponse;
import org.apache.seata.core.protocol.transaction.BranchRollbackRequest;
import org.apache.seata.core.protocol.transaction.BranchRollbackResponse;
import org.apache.seata.core.protocol.transaction.UndoLogDeleteRequest;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.mockserver.model.MockBranchSession;

public class CallRm {
    public static BranchStatus branchCommit(RemotingServer remotingServer, MockBranchSession branchSession) {
        BranchCommitRequest request = new BranchCommitRequest();
        CallRm.setReq((AbstractBranchEndRequest)request, branchSession);
        try {
            BranchCommitResponse response = (BranchCommitResponse)remotingServer.sendSyncRequest(branchSession.getResourceId(), branchSession.getClientId(), (Object)request, false);
            return response.getBranchStatus();
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static BranchStatus branchRollback(RemotingServer remotingServer, MockBranchSession branchSession) {
        BranchRollbackRequest request = new BranchRollbackRequest();
        CallRm.setReq((AbstractBranchEndRequest)request, branchSession);
        try {
            BranchRollbackResponse response = (BranchRollbackResponse)remotingServer.sendSyncRequest(branchSession.getResourceId(), branchSession.getClientId(), (Object)request, false);
            return response.getBranchStatus();
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteUndoLog(RemotingServer remotingServer, MockBranchSession branchSession) {
        UndoLogDeleteRequest request = new UndoLogDeleteRequest();
        request.setResourceId(branchSession.getResourceId());
        request.setSaveDays((short)1);
        request.setBranchType(BranchType.TCC);
        try {
            Channel channel = ChannelManager.getChannel((String)branchSession.getResourceId(), (String)branchSession.getClientId(), (boolean)false);
            remotingServer.sendAsyncRequest(channel, (Object)request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setReq(AbstractBranchEndRequest request, MockBranchSession branchSession) {
        request.setXid(branchSession.getXid());
        request.setBranchId(branchSession.getBranchId());
        request.setResourceId(branchSession.getResourceId());
        request.setApplicationData(branchSession.getApplicationData());
        request.setBranchType(branchSession.getBranchType());
    }
}

