/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver;

import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.XID;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.NumberUtils;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.netty.NettyServerConfig;
import org.apache.seata.mockserver.MockCoordinator;
import org.apache.seata.mockserver.MockNettyRemotingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class MockServer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MockServer.class);
    private static ThreadPoolExecutor workingThreads;
    private static MockNettyRemotingServer nettyRemotingServer;
    private static volatile boolean inited;
    public static final int DEFAULT_PORT = 8091;

    public static void main(String[] args) {
        SpringApplication.run(MockServer.class, (String[])args);
        int port = NumberUtils.toInt((String)System.getenv("SEATA_PORT"), (int)8091);
        MockServer.start(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void start(int port) {
        if (inited) return;
        Class<MockServer> clazz = MockServer.class;
        synchronized (MockServer.class) {
            if (inited) return;
            inited = true;
            workingThreads = new ThreadPoolExecutor(50, 50, 500L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20000), (ThreadFactory)new NamedThreadFactory("ServerHandlerThread", 500), new ThreadPoolExecutor.CallerRunsPolicy());
            NettyServerConfig config = new NettyServerConfig();
            config.setServerListenPort(port);
            nettyRemotingServer = new MockNettyRemotingServer(workingThreads, config);
            XID.setIpAddress((String)NetUtil.getLocalIp((String[])new String[0]));
            XID.setPort((int)port);
            Instance.getInstance().setTransaction(new Node.Endpoint(XID.getIpAddress(), XID.getPort(), "netty"));
            UUIDGenerator.init((Long)1L);
            MockCoordinator coordinator = MockCoordinator.getInstance();
            coordinator.setRemotingServer((RemotingServer)nettyRemotingServer);
            nettyRemotingServer.setHandler(coordinator);
            nettyRemotingServer.init();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("system is closing , pid info: " + ManagementFactory.getRuntimeMXBean().getName());
                }
            }));
            LOGGER.info("pid info: " + ManagementFactory.getRuntimeMXBean().getName());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void close() {
        if (!inited) return;
        Class<MockServer> clazz = MockServer.class;
        synchronized (MockServer.class) {
            if (!inited) return;
            inited = false;
            workingThreads.shutdown();
            nettyRemotingServer.destroy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        inited = false;
    }
}

