/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver;

import io.netty.channel.Channel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.AbstractNettyRemotingServer;
import org.apache.seata.core.rpc.netty.NettyServerConfig;
import org.apache.seata.core.rpc.processor.RemotingProcessor;
import org.apache.seata.mockserver.processor.MockHeartbeatProcessor;
import org.apache.seata.mockserver.processor.MockOnReqProcessor;
import org.apache.seata.mockserver.processor.MockOnRespProcessor;
import org.apache.seata.mockserver.processor.MockRegisterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockNettyRemotingServer
extends AbstractNettyRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockNettyRemotingServer.class);
    private TransactionMessageHandler handler;

    public void setHandler(TransactionMessageHandler transactionMessageHandler) {
        this.handler = transactionMessageHandler;
    }

    public void init() {
        this.registerProcessor();
        super.init();
    }

    public MockNettyRemotingServer(ThreadPoolExecutor messageExecutor) {
        this(messageExecutor, new NettyServerConfig());
    }

    public MockNettyRemotingServer(ThreadPoolExecutor messageExecutor, NettyServerConfig nettyServerConfig) {
        super(messageExecutor, nettyServerConfig);
    }

    public void destroyChannel(String serverAddress, Channel channel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will destroy channel:{},address:{}", (Object)channel, (Object)serverAddress);
        }
        channel.disconnect();
        channel.close();
    }

    private void registerProcessor() {
        MockOnReqProcessor onRequestProcessor = new MockOnReqProcessor((RemotingServer)this, this.handler);
        super.registerProcessor(11, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(13, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(1, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(7, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(21, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(17, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(9, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(15, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(59, (RemotingProcessor)onRequestProcessor, (ExecutorService)this.messageExecutor);
        MockOnRespProcessor onResponseProcessor = new MockOnRespProcessor((RemotingServer)this, this.handler, this.getFutures());
        super.registerProcessor(4, (RemotingProcessor)onResponseProcessor, (ExecutorService)this.messageExecutor);
        super.registerProcessor(6, (RemotingProcessor)onResponseProcessor, (ExecutorService)this.messageExecutor);
        MockRegisterProcessor regRmProcessor = new MockRegisterProcessor((RemotingServer)this, MockRegisterProcessor.Role.RM);
        super.registerProcessor(103, (RemotingProcessor)regRmProcessor, (ExecutorService)this.messageExecutor);
        MockRegisterProcessor regTmProcessor = new MockRegisterProcessor((RemotingServer)this, MockRegisterProcessor.Role.TM);
        super.registerProcessor(101, (RemotingProcessor)regTmProcessor, null);
        MockHeartbeatProcessor heartbeatMessageProcessor = new MockHeartbeatProcessor((RemotingServer)this, this.handler);
        super.registerProcessor(120, (RemotingProcessor)heartbeatMessageProcessor, null);
    }

    public void destroy() {
        super.destroy();
    }
}

