/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.ResultCode;
import org.apache.seata.core.protocol.Version;
import org.apache.seata.core.protocol.transaction.AbstractGlobalEndResponse;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.core.protocol.transaction.BranchRegisterResponse;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.core.protocol.transaction.BranchReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.protocol.transaction.GlobalCommitRequest;
import org.apache.seata.core.protocol.transaction.GlobalCommitResponse;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryRequest;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryResponse;
import org.apache.seata.core.protocol.transaction.GlobalReportRequest;
import org.apache.seata.core.protocol.transaction.GlobalReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalRollbackRequest;
import org.apache.seata.core.protocol.transaction.GlobalRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalStatusRequest;
import org.apache.seata.core.protocol.transaction.GlobalStatusResponse;
import org.apache.seata.core.protocol.transaction.TCInboundHandler;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.mockserver.call.CallRm;
import org.apache.seata.mockserver.model.MockBranchSession;
import org.apache.seata.mockserver.model.MockGlobalSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockCoordinator
implements TCInboundHandler,
TransactionMessageHandler,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MockCoordinator.class);
    RemotingServer remotingServer;
    private static MockCoordinator coordinator;
    private static String AllBeginFailXid;
    private Map<String, GlobalStatus> globalStatusMap;
    private Map<String, ResultCode> expectedResultMap;
    private Map<String, Integer> expectRetryTimesMap;
    private Map<String, List<MockBranchSession>> branchMap;

    private MockCoordinator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MockCoordinator getInstance() {
        if (coordinator != null) return coordinator;
        Class<MockCoordinator> clazz = MockCoordinator.class;
        synchronized (MockCoordinator.class) {
            if (coordinator != null) return coordinator;
            coordinator = new MockCoordinator();
            MockCoordinator.coordinator.expectedResultMap = new ConcurrentHashMap<String, ResultCode>();
            MockCoordinator.coordinator.globalStatusMap = new ConcurrentHashMap<String, GlobalStatus>();
            MockCoordinator.coordinator.expectRetryTimesMap = new ConcurrentHashMap<String, Integer>();
            MockCoordinator.coordinator.branchMap = new ConcurrentHashMap<String, List<MockBranchSession>>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return coordinator;
        }
    }

    public void destroy() {
    }

    public AbstractResultMessage onRequest(AbstractMessage request, RpcContext context) {
        if (!(request instanceof AbstractTransactionRequestToTC)) {
            throw new IllegalArgumentException();
        }
        AbstractTransactionRequestToTC transactionRequest = (AbstractTransactionRequestToTC)request;
        transactionRequest.setTCInboundHandler((TCInboundHandler)this);
        return transactionRequest.handle(context);
    }

    public void onResponse(AbstractResultMessage response, RpcContext context) {
        response.setResultCode(ResultCode.Success);
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    public void setExpectedResult(String xid, ResultCode expected) {
        this.expectedResultMap.put(xid, expected);
    }

    public void setExpectedRetry(String xid, int times) {
        this.expectRetryTimesMap.put(xid, times);
    }

    private void checkMockActionFail(String xid) throws TransactionException {
        if (ResultCode.Failed == this.expectedResultMap.get(xid)) {
            throw new TransactionException(TransactionExceptionCode.Broken, "mock action expect fail");
        }
    }

    private <T extends AbstractTransactionResponse> T handleException(TransactionException e, T response, ResultCode resultCode, String messagePrefix, GlobalStatus ... globalStatus) {
        response.setTransactionExceptionCode(e.getCode());
        response.setResultCode(resultCode);
        response.setMsg(messagePrefix + "[" + e.getMessage() + "]");
        if (response instanceof AbstractGlobalEndResponse && globalStatus != null && globalStatus.length > 0) {
            ((AbstractGlobalEndResponse)response).setGlobalStatus(globalStatus[0]);
        }
        return response;
    }

    public GlobalBeginResponse handle(GlobalBeginRequest request, RpcContext rpcContext) {
        GlobalBeginResponse response = new GlobalBeginResponse();
        try {
            this.checkMockActionFail(AllBeginFailXid);
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockBeginException", new GlobalStatus[0]);
        }
        MockGlobalSession session = new MockGlobalSession(rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout());
        this.globalStatusMap.putIfAbsent(session.getXid(), GlobalStatus.Begin);
        response.setXid(session.getXid());
        response.setResultCode(ResultCode.Success);
        return response;
    }

    public GlobalCommitResponse handle(GlobalCommitRequest request, RpcContext rpcContext) {
        GlobalCommitResponse response = new GlobalCommitResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockCommitException", GlobalStatus.CommitFailed);
        }
        response.setGlobalStatus(GlobalStatus.Committed);
        response.setResultCode(ResultCode.Success);
        this.globalStatusMap.put(request.getXid(), GlobalStatus.Committed);
        int retry = this.expectRetryTimesMap.getOrDefault(request.getXid(), 0);
        List<MockBranchSession> branchSessions = this.branchMap.get(request.getXid());
        if (CollectionUtils.isEmpty(branchSessions)) {
            LOGGER.warn("[doGlobalCommit]branchSessions is empty,XID=" + request.getXid());
            return response;
        }
        branchSessions.forEach(branch -> {
            CallRm.branchCommit(this.remotingServer, branch);
            IntStream.range(0, retry).forEach(i -> CallRm.branchCommit(this.remotingServer, branch));
        });
        this.branchMap.remove(request.getXid());
        this.globalStatusMap.remove(request.getXid());
        return response;
    }

    public GlobalRollbackResponse handle(GlobalRollbackRequest request, RpcContext rpcContext) {
        GlobalRollbackResponse response = new GlobalRollbackResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockRollbackException", GlobalStatus.RollbackFailed);
        }
        response.setGlobalStatus(GlobalStatus.Rollbacked);
        response.setResultCode(ResultCode.Success);
        this.globalStatusMap.put(request.getXid(), GlobalStatus.Rollbacked);
        int retry = this.expectRetryTimesMap.getOrDefault(request.getXid(), 0);
        List<MockBranchSession> branchSessions = this.branchMap.get(request.getXid());
        if (CollectionUtils.isEmpty(branchSessions)) {
            LOGGER.warn("[doGlobalRollback]branchSessions is empty,XID=" + request.getXid());
            return response;
        }
        branchSessions.forEach(branch -> {
            CallRm.branchRollback(this.remotingServer, branch);
            IntStream.range(0, retry).forEach(i -> CallRm.branchRollback(this.remotingServer, branch));
            if (Version.isV0((String)rpcContext.getVersion())) {
                CallRm.deleteUndoLog(this.remotingServer, branch);
            }
        });
        this.branchMap.remove(request.getXid());
        this.globalStatusMap.remove(request.getXid());
        return response;
    }

    public BranchRegisterResponse handle(BranchRegisterRequest request, RpcContext rpcContext) {
        BranchRegisterResponse response = new BranchRegisterResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockBranchRegisterException", new GlobalStatus[0]);
        }
        MockBranchSession branchSession = new MockBranchSession(request.getBranchType());
        String xid = request.getXid();
        branchSession.setXid(xid);
        branchSession.setBranchId(UUIDGenerator.generateUUID());
        branchSession.setResourceId(request.getResourceId());
        branchSession.setLockKey(request.getLockKey());
        branchSession.setClientId(rpcContext.getClientId());
        branchSession.setApplicationData(request.getApplicationData());
        branchSession.setStatus(BranchStatus.Registered);
        this.branchMap.compute(xid, (key, val) -> {
            if (val == null) {
                val = new ArrayList<MockBranchSession>();
            }
            val.add(branchSession);
            return val;
        });
        response.setBranchId(branchSession.getBranchId());
        response.setResultCode(ResultCode.Success);
        return response;
    }

    public BranchReportResponse handle(BranchReportRequest request, RpcContext rpcContext) {
        BranchReportResponse response = new BranchReportResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockBranchReportException", new GlobalStatus[0]);
        }
        String xid = request.getXid();
        this.branchMap.compute(xid, (key, val) -> {
            if (val != null) {
                val.stream().filter(branch -> branch.getBranchId() == request.getBranchId()).forEach(branch -> branch.setApplicationData(request.getApplicationData()));
            }
            return val;
        });
        response.setResultCode(ResultCode.Success);
        return response;
    }

    public GlobalLockQueryResponse handle(GlobalLockQueryRequest request, RpcContext rpcContext) {
        GlobalLockQueryResponse response = new GlobalLockQueryResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockLockQueryException", new GlobalStatus[0]);
        }
        response.setLockable(true);
        response.setResultCode(ResultCode.Success);
        return response;
    }

    public GlobalStatusResponse handle(GlobalStatusRequest request, RpcContext rpcContext) {
        GlobalStatusResponse response = new GlobalStatusResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockStatusException", GlobalStatus.Finished);
        }
        GlobalStatus globalStatus = this.globalStatusMap.get(request.getXid());
        if (globalStatus == null) {
            globalStatus = GlobalStatus.Finished;
        }
        response.setGlobalStatus(globalStatus);
        response.setResultCode(ResultCode.Success);
        return response;
    }

    public GlobalReportResponse handle(GlobalReportRequest request, RpcContext rpcContext) {
        GlobalReportResponse response = new GlobalReportResponse();
        try {
            this.checkMockActionFail(request.getXid());
        }
        catch (TransactionException e) {
            return this.handleException(e, response, ResultCode.Failed, "MockReportException", GlobalStatus.Finished);
        }
        GlobalStatus globalStatus = request.getGlobalStatus();
        this.globalStatusMap.put(request.getXid(), globalStatus);
        response.setGlobalStatus(globalStatus);
        response.setResultCode(ResultCode.Success);
        return response;
    }

    static {
        AllBeginFailXid = "0";
    }
}

