/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.exception.ConfigNotFoundException;
import org.apache.seata.discovery.registry.RegistryService;

public class FileRegistryServiceImpl
implements RegistryService<ConfigChangeListener> {
    private static volatile FileRegistryServiceImpl instance;
    private static final Configuration CONFIG;
    private static final String POSTFIX_GROUPLIST = ".grouplist";
    private static final String ENDPOINT_SPLIT_CHAR = ";";

    private FileRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FileRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<FileRegistryServiceImpl> clazz = FileRegistryServiceImpl.class;
        synchronized (FileRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new FileRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
    }

    @Override
    public void subscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    @Override
    public void unsubscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            String missingDataId = "service.vgroupMapping." + key;
            throw new ConfigNotFoundException("%s configuration item is required", new String[]{missingDataId});
        }
        String endpointStr = this.getGroupListFromConfig(clusterName);
        String[] endpoints = endpointStr.split(ENDPOINT_SPLIT_CHAR);
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>();
        for (String endpoint : endpoints) {
            String[] ipAndPort = NetUtil.splitIPPortStr((String)endpoint);
            inetSocketAddresses.add(new InetSocketAddress(ipAndPort[0], Integer.parseInt(ipAndPort[1])));
        }
        return inetSocketAddresses;
    }

    private String getGroupListFromConfig(String clusterName) {
        String oldGrouplistDataId = "service." + clusterName + POSTFIX_GROUPLIST;
        String endpointStr = CONFIG.getConfig(oldGrouplistDataId);
        if (StringUtils.isNullOrEmpty((String)endpointStr)) {
            String newGrouplistDataId = "service.grouplist." + clusterName;
            throw new ConfigNotFoundException("%s or %s configuration item is required", new String[]{oldGrouplistDataId, newGrouplistDataId});
        }
        return endpointStr;
    }

    @Override
    public void close() throws Exception {
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

