/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryProvider;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.RegistryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiRegistryFactory.class);

    public static List<RegistryService> getInstances() {
        return MultiRegistryFactoryHolder.INSTANCES;
    }

    private static List<RegistryService> buildRegistryServices() {
        String[] registryTypeNames;
        ArrayList<RegistryService> registryServices = new ArrayList<RegistryService>();
        String registryTypeNamesStr = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        if (StringUtils.isBlank((String)registryTypeNamesStr)) {
            registryTypeNamesStr = RegistryType.File.name();
        }
        if ((registryTypeNames = registryTypeNamesStr.split(",")).length > 1) {
            LOGGER.info("use multi registry center type: {}", (Object)registryTypeNamesStr);
        }
        for (String registryTypeName : registryTypeNames) {
            RegistryType registryType;
            try {
                registryType = RegistryType.getType(registryTypeName);
            }
            catch (Exception exx) {
                throw new NotSupportYetException("not support registry type: " + registryTypeName);
            }
            RegistryService registryService = ((RegistryProvider)EnhancedServiceLoader.load(RegistryProvider.class, (String)Objects.requireNonNull(registryType).name())).provide();
            registryServices.add(registryService);
        }
        return registryServices;
    }

    static /* synthetic */ List access$100() {
        return MultiRegistryFactory.buildRegistryServices();
    }

    private static class MultiRegistryFactoryHolder {
        private static final List<RegistryService> INSTANCES = MultiRegistryFactory.access$100();

        private MultiRegistryFactoryHolder() {
        }
    }
}

