/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.CertAuthenticator;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.table.remote.couchbase.CouchbaseEnvironmentConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseBucketRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseBucketRegistry.class);
    private final Map<String, Bucket> openedBuckets = new HashMap<String, Bucket>();
    private final Map<String, Cluster> openedClusters = new HashMap<String, Cluster>();
    private final Map<String, Integer> bucketUsageCounts = new HashMap<String, Integer>();
    private final Map<String, Integer> clusterUsageCounts = new HashMap<String, Integer>();

    public synchronized Bucket getBucket(String bucketName, List<String> clusterNodes, CouchbaseEnvironmentConfigs configs) {
        String bucketId = this.getBucketId(bucketName, clusterNodes);
        String clusterId = this.getClusterId(clusterNodes);
        if (!this.openedClusters.containsKey(clusterId)) {
            this.openedClusters.put(clusterId, this.openCluster(clusterNodes, configs));
        }
        if (!this.openedBuckets.containsKey(bucketId)) {
            this.openedBuckets.put(bucketId, this.openBucket(bucketName, this.openedClusters.get(clusterId)));
        }
        this.bucketUsageCounts.put(bucketId, this.bucketUsageCounts.getOrDefault(bucketId, 0) + 1);
        this.clusterUsageCounts.put(clusterId, this.clusterUsageCounts.getOrDefault(clusterId, 0) + 1);
        return this.openedBuckets.get(bucketId);
    }

    public synchronized boolean closeBucket(String bucketName, List<String> clusterNodes) {
        String bucketId = this.getBucketId(bucketName, clusterNodes);
        String clusterId = this.getClusterId(clusterNodes);
        if (!this.openedBuckets.containsKey(bucketId) || !this.openedClusters.containsKey(clusterId)) {
            return false;
        }
        this.bucketUsageCounts.put(bucketId, this.bucketUsageCounts.get(bucketId) - 1);
        this.clusterUsageCounts.put(clusterId, this.clusterUsageCounts.get(clusterId) - 1);
        Boolean bucketClosed = true;
        Boolean clusterClosed = true;
        if (this.bucketUsageCounts.get(bucketId) == 0) {
            bucketClosed = this.openedBuckets.get(bucketId).close();
            this.openedBuckets.remove(bucketId);
            this.bucketUsageCounts.remove(bucketId);
            if (this.clusterUsageCounts.get(clusterId) == 0) {
                clusterClosed = this.openedClusters.get(clusterId).disconnect();
                this.openedClusters.remove(clusterId);
                this.clusterUsageCounts.remove(clusterId);
            }
        }
        return bucketClosed != false && clusterClosed != false;
    }

    private Cluster openCluster(List<String> clusterNodes, CouchbaseEnvironmentConfigs configs) {
        DefaultCouchbaseEnvironment.Builder envBuilder = new DefaultCouchbaseEnvironment.Builder();
        if (configs.sslEnabled != null) {
            envBuilder.sslEnabled(configs.sslEnabled.booleanValue());
        }
        if (configs.certAuthEnabled != null) {
            envBuilder.certAuthEnabled(configs.certAuthEnabled.booleanValue());
        }
        if (configs.sslKeystoreFile != null) {
            envBuilder.sslKeystoreFile(configs.sslKeystoreFile);
        }
        if (configs.sslKeystorePassword != null) {
            envBuilder.sslKeystorePassword(configs.sslKeystorePassword);
        }
        if (configs.sslTruststoreFile != null) {
            envBuilder.sslTruststoreFile(configs.sslTruststoreFile);
        }
        if (configs.sslTruststorePassword != null) {
            envBuilder.sslTruststorePassword(configs.sslTruststorePassword);
        }
        if (configs.bootstrapCarrierDirectPort != null) {
            envBuilder.bootstrapCarrierDirectPort(configs.bootstrapCarrierDirectPort.intValue());
        }
        if (configs.bootstrapCarrierSslPort != null) {
            envBuilder.bootstrapCarrierSslPort(configs.bootstrapCarrierSslPort.intValue());
        }
        if (configs.bootstrapHttpDirectPort != null) {
            envBuilder.bootstrapHttpDirectPort(configs.bootstrapHttpDirectPort.intValue());
        }
        if (configs.bootstrapHttpSslPort != null) {
            envBuilder.bootstrapHttpSslPort(configs.bootstrapHttpSslPort.intValue());
        }
        DefaultCouchbaseEnvironment env = envBuilder.build();
        CouchbaseCluster cluster = CouchbaseCluster.create((CouchbaseEnvironment)env, clusterNodes);
        if (configs.sslEnabled != null && configs.sslEnabled.booleanValue()) {
            cluster.authenticate((Authenticator)CertAuthenticator.INSTANCE);
        } else if (configs.username != null) {
            cluster.authenticate(configs.username, configs.password);
        } else {
            LOGGER.warn("No authentication is enabled for cluster: {}. This is not recommended except for test cases.", clusterNodes);
        }
        return cluster;
    }

    private Bucket openBucket(String bucketName, Cluster cluster) {
        return cluster.openBucket(bucketName);
    }

    private String getBucketId(String bucketName, List<String> clusterNodes) {
        return this.getClusterId(clusterNodes) + "-" + bucketName;
    }

    private String getClusterId(List<String> clusterNodes) {
        return clusterNodes.toString();
    }
}

