/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.context.Context;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.AsyncReadWriteTable;
import org.apache.samza.table.remote.BaseTableFunction;
import org.apache.samza.table.remote.couchbase.CouchbaseBucketRegistry;
import org.apache.samza.table.remote.couchbase.CouchbaseEnvironmentConfigs;

public abstract class BaseCouchbaseTableFunction<V>
extends BaseTableFunction {
    private static final CouchbaseBucketRegistry COUCHBASE_BUCKET_REGISTRY = new CouchbaseBucketRegistry();
    protected transient Bucket bucket;
    protected Serde<V> valueSerde = null;
    protected Duration timeout = Duration.ZERO;
    protected Duration ttl = Duration.ZERO;
    protected final List<String> clusterNodes;
    protected final String bucketName;
    protected final CouchbaseEnvironmentConfigs environmentConfigs;

    public BaseCouchbaseTableFunction(String bucketName, Class<V> valueClass, String ... clusterNodes) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)bucketName), (Object)"Bucket name is not allowed to be null or empty.");
        Preconditions.checkArgument((valueClass != null ? 1 : 0) != 0, (Object)"Value class is not allowed to be null.");
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])clusterNodes), (Object)"Cluster nodes is not allowed to be null or empty.");
        this.bucketName = bucketName;
        this.clusterNodes = ImmutableList.copyOf((Object[])clusterNodes);
        this.environmentConfigs = new CouchbaseEnvironmentConfigs();
    }

    public void init(Context context, AsyncReadWriteTable table) {
        super.init(context, table);
        this.bucket = COUCHBASE_BUCKET_REGISTRY.getBucket(this.bucketName, this.clusterNodes, this.environmentConfigs);
    }

    public void close() {
        COUCHBASE_BUCKET_REGISTRY.closeBucket(this.bucketName, this.clusterNodes);
    }

    public boolean isRetriable(Throwable exception) {
        while (!(exception == null || exception instanceof TemporaryFailureException || exception instanceof TemporaryLockFailureException || exception instanceof TimeoutException)) {
            exception = exception.getCause();
        }
        return exception != null;
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withTimeout(Duration timeout) {
        Preconditions.checkArgument((timeout != null && !timeout.isNegative() ? 1 : 0) != 0, (Object)"Timeout should not be null or negative");
        this.timeout = timeout;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withTtl(Duration ttl) {
        Preconditions.checkArgument((ttl != null && !ttl.isNegative() ? 1 : 0) != 0, (Object)"TTL should not be null or negative");
        this.ttl = ttl;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withSerde(Serde<V> valueSerde) {
        this.valueSerde = valueSerde;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withUsernameAndPassword(String username, String password) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)username), (Object)"username should not be null or empty.");
        if (this.environmentConfigs.sslEnabled != null && this.environmentConfigs.sslEnabled.booleanValue()) {
            throw new IllegalArgumentException("Role-Based Access Control and Certificate-Based Authentication cannot be used together.");
        }
        this.environmentConfigs.username = username;
        this.environmentConfigs.password = password;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withSslEnabledAndCertAuthEnabled(boolean certAuthEnabled) {
        if (this.environmentConfigs.username != null) {
            throw new IllegalArgumentException("Role-Based Access Control and Certificate-Based Authentication cannot be used together.");
        }
        this.environmentConfigs.sslEnabled = true;
        this.environmentConfigs.certAuthEnabled = certAuthEnabled;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withSslKeystoreFileAndPassword(String sslKeystoreFile, String sslKeystorePassword) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sslKeystoreFile), (Object)"Null or empty sslKeystoreFile");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sslKeystorePassword), (Object)"Null or empty sslKeystorePassword");
        this.environmentConfigs.sslKeystoreFile = sslKeystoreFile;
        this.environmentConfigs.sslKeystorePassword = sslKeystorePassword;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withSslTruststoreFileAndPassword(String sslTruststoreFile, String sslTruststorePassword) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sslTruststoreFile), (Object)"Null or empty sslTruststoreFile");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sslTruststorePassword), (Object)"Null or empty sslTruststorePassword");
        this.environmentConfigs.sslTruststoreFile = sslTruststoreFile;
        this.environmentConfigs.sslTruststorePassword = sslTruststorePassword;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withBootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
        this.environmentConfigs.bootstrapCarrierDirectPort = bootstrapCarrierDirectPort;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withBootstrapCarrierSslPort(int bootstrapCarrierSslPort) {
        this.environmentConfigs.bootstrapCarrierSslPort = bootstrapCarrierSslPort;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withBootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
        this.environmentConfigs.bootstrapHttpDirectPort = bootstrapHttpDirectPort;
        return (T)((Object)this);
    }

    public <T extends BaseCouchbaseTableFunction<V>> T withBootstrapHttpSslPort(int bootstrapHttpSslPort) {
        this.environmentConfigs.bootstrapHttpSslPort = bootstrapHttpSslPort;
        return (T)((Object)this);
    }
}

