/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.autoscaling.utils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnUtil {
    private static final Logger log = LoggerFactory.getLogger(YarnUtil.class);
    private CloseableHttpClient httpclient = HttpClientBuilder.create().build();
    private HttpHost rmServer;
    private YarnClient yarnClient;

    public YarnUtil(String rmAddress, int rmPort) {
        this.rmServer = new HttpHost(rmAddress, rmPort, "http");
        log.info("setting rm server to : " + this.rmServer);
        YarnConfiguration hConfig = new YarnConfiguration();
        hConfig.set("yarn.resourcemanager.address", rmAddress + ":" + 8032);
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init((Configuration)hConfig);
        this.yarnClient.start();
    }

    public String getRunningAppId(String jobName, int jobID) {
        try {
            HttpGet getRequest = new HttpGet("/ws/v1/cluster/apps");
            CloseableHttpResponse httpResponse = this.httpclient.execute(this.rmServer, (HttpRequest)getRequest);
            String applications = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            log.debug("applications: " + applications);
            List<Map<String, String>> applicationList = this.parseYarnApplications(applications);
            String name = jobName + "_" + jobID;
            for (Map<String, String> application : applicationList) {
                if (!application.containsKey("state") || !application.containsKey("name") || !application.containsKey("id") || !application.get("state").toString().equals("RUNNING") || !application.get("name").toString().equals(name)) continue;
                return application.get("id").toString();
            }
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            throw new IllegalStateException("there is no valid application id for the given job name and job id. job name: " + jobName + " job id: " + jobID);
        }
        return null;
    }

    List<Map<String, String>> parseYarnApplications(String applications) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map yarnApplications = (Map)mapper.readValue(applications, (TypeReference)new TypeReference<Map<String, Map<String, List<Map<String, Object>>>>>(){});
        return (List)((Map)yarnApplications.get("apps")).get("app");
    }

    public String getApplicationState(String applicationId) throws IOException, YarnException {
        return this.yarnClient.getApplicationReport(this.getApplicationIDFromString(applicationId)).getYarnApplicationState().toString();
    }

    public void killApplication(String applicationId) throws IOException, YarnException {
        log.info("killing job with application id: " + applicationId);
        this.yarnClient.killApplication(this.getApplicationIDFromString(applicationId));
    }

    private ApplicationId getApplicationIDFromString(String appIDStr) {
        String[] parts = appIDStr.split("_");
        if (parts.length < 3) {
            throw new IllegalStateException("the application id found is not valid. application id: " + appIDStr);
        }
        long timestamp = Long.valueOf(parts[1]);
        int id = Integer.valueOf(parts[2]);
        return ApplicationId.newInstance((long)timestamp, (int)id);
    }

    public void stop() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            log.error("HTTP Client failed to close.", (Throwable)e);
        }
        this.yarnClient.stop();
    }
}

