/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell.util;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.rya.streams.api.entity.StreamsQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.queryrender.sparql.SPARQLQueryRenderer;

@DefaultAnnotation(value={NonNull.class})
public final class StreamsQueryFormatter {
    public static String format(StreamsQuery query) throws Exception {
        Objects.requireNonNull(query);
        ParsedQuery parsedQuery = new SPARQLParser().parseQuery(query.getSparql(), null);
        String prettySparql = new SPARQLQueryRenderer().render(parsedQuery);
        String[] lines = prettySparql.split("\n");
        query.getQueryId();
        query.isActive();
        String.format(" QueryId: %s", query.getQueryId());
        StringBuilder builder = new StringBuilder();
        builder.append(" Query ID: ").append(query.getQueryId()).append("\n");
        builder.append("Is Active: ").append(query.isActive()).append("\n");
        builder.append("   SPARQL: ").append(lines[0]).append("\n");
        for (int i = 1; i < lines.length; ++i) {
            builder.append("           ").append(lines[i]).append("\n");
        }
        return builder.toString();
    }

    public static String format(Collection<StreamsQuery> queries) throws Exception {
        Objects.requireNonNull(queries);
        if (queries.size() == 1) {
            return StreamsQueryFormatter.format(queries.iterator().next());
        }
        ArrayList sorted = Lists.newArrayList(queries);
        sorted.sort((query1, query2) -> {
            String id1 = query1.getQueryId().toString();
            String id2 = query2.getQueryId().toString();
            return id1.compareTo(id2);
        });
        StringBuilder builder = new StringBuilder();
        builder.append("-----------------------------------------------\n");
        for (StreamsQuery query : sorted) {
            builder.append(StreamsQueryFormatter.format(query));
            builder.append("-----------------------------------------------\n");
        }
        return builder.toString();
    }
}

