/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell.util;

import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import jline.console.ConsoleReader;
import org.apache.rya.shell.util.JLinePrompt;

@DefaultAnnotation(value={NonNull.class})
public interface SparqlPrompt {
    public Optional<String> getSparql() throws IOException;

    @DefaultAnnotation(value={NonNull.class})
    public static class JLineSparqlPrompt
    extends JLinePrompt
    implements SparqlPrompt {
        private final String EXECUTE_COMMAND = "\\e";
        private final String CLEAR_COMMAND = "\\c";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<String> getSparql() throws IOException {
            ConsoleReader reader = this.getReader();
            reader.setCopyPasteDetection(true);
            reader.setHistoryEnabled(false);
            try {
                reader.println((CharSequence)"Enter a SPARQL Query.");
                reader.println((CharSequence)"Type '\\e' to execute the current query.");
                reader.println((CharSequence)"Type '\\c' to clear the current query.");
                reader.flush();
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine("SPARQL> ");
                while (!line.endsWith("\\c") && !line.endsWith("\\e")) {
                    sb.append(line).append("\n");
                    line = reader.readLine("     -> ");
                }
                if (line.endsWith("\\e")) {
                    sb.append(line.substring(0, line.length() - "\\e".length()));
                    Optional optional = Optional.of((Object)sb.toString());
                    return optional;
                }
                Optional optional = Optional.absent();
                return optional;
            }
            finally {
                reader.setHistoryEnabled(true);
                reader.setCopyPasteDetection(false);
            }
        }
    }
}

