/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.shell.SharedShellState;

@DefaultAnnotation(value={NonNull.class})
public class RyaDetailsFormatter {
    public String format(SharedShellState.StorageType storageType, RyaDetails details) {
        Objects.requireNonNull(details);
        StringBuilder report = new StringBuilder();
        report.append("General Metadata:\n");
        report.append("  Instance Name: ").append(details.getRyaInstanceName()).append("\n");
        report.append("  RYA Version: ").append(details.getRyaVersion()).append("\n");
        if (storageType == SharedShellState.StorageType.ACCUMULO) {
            report.append("  Users: ").append(Joiner.on((String)", ").join((Iterable)details.getUsers())).append("\n");
        }
        report.append("Secondary Indicies:\n");
        if (storageType == SharedShellState.StorageType.ACCUMULO) {
            report.append("  Entity Centric Index:\n");
            report.append("    Enabled: ").append(details.getEntityCentricIndexDetails().isEnabled()).append("\n");
        }
        report.append("  Free Text Index:\n");
        report.append("    Enabled: ").append(details.getFreeTextIndexDetails().isEnabled()).append("\n");
        report.append("  Temporal Index:\n");
        report.append("    Enabled: ").append(details.getTemporalIndexDetails().isEnabled()).append("\n");
        report.append("  PCJ Index:\n");
        RyaDetails.PCJIndexDetails pcjDetails = details.getPCJIndexDetails();
        report.append("    Enabled: ").append(pcjDetails.isEnabled()).append("\n");
        if (pcjDetails.isEnabled()) {
            if (pcjDetails.getFluoDetails().isPresent()) {
                String fluoAppName = ((RyaDetails.PCJIndexDetails.FluoDetails)pcjDetails.getFluoDetails().get()).getUpdateAppName();
                report.append("    Fluo App Name: ").append(fluoAppName).append("\n");
            }
            ImmutableMap pcjs = pcjDetails.getPCJDetails();
            report.append("    PCJs:\n");
            if (pcjs.isEmpty()) {
                report.append("      No PCJs have been added yet.\n");
            } else {
                for (RyaDetails.PCJIndexDetails.PCJDetails pcj : pcjs.values()) {
                    report.append("      ID: ").append(pcj.getId()).append("\n");
                    String updateStrategy = this.format(pcj.getUpdateStrategy(), "None");
                    report.append("        Update Strategy: ").append(updateStrategy).append("\n");
                    String lastUpdateTime = this.format(pcj.getLastUpdateTime(), "unavailable");
                    report.append("        Last Update Time: ").append(lastUpdateTime).append("\n");
                }
            }
            if (storageType == SharedShellState.StorageType.ACCUMULO) {
                report.append("Statistics:\n");
                report.append("  Prospector:\n");
                String prospectorLastUpdateTime = this.format(details.getProspectorDetails().getLastUpdated(), "unavailable");
                report.append("    Last Update Time: ").append(prospectorLastUpdateTime).append("\n");
                report.append("  Join Selectivity:\n");
                String jsLastUpdateTime = this.format(details.getJoinSelectivityDetails().getLastUpdated(), "unavailable");
                report.append("    Last Updated Time: ").append(jsLastUpdateTime).append("\n");
            }
        }
        return report.toString();
    }

    private <T> String format(Optional<T> value, String absentValue) {
        Objects.requireNonNull(value);
        String formatted = "unavailable";
        if (value.isPresent()) {
            formatted = value.get().toString();
        }
        return formatted;
    }
}

