/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell.util;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import jline.console.ConsoleReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.util.FieldUtils;
import org.springframework.shell.core.Shell;

@DefaultAnnotation(value={NonNull.class})
public abstract class JLinePrompt {
    private static final Set<String> affirmativeStrings = Sets.newHashSet((Object[])new String[]{"true", "t", "yes", "y"});
    private static final Set<String> negativeStrings = Sets.newHashSet((Object[])new String[]{"false", "f", "no", "n"});
    @Autowired
    private Shell shell;

    public ConsoleReader getReader() {
        return (ConsoleReader)FieldUtils.getProtectedFieldValue((String)"reader", (Object)this.shell);
    }

    public String makeFieldPrompt(String fieldName, boolean defaultValue) {
        return this.makeFieldPrompt(fieldName, Boolean.toString(defaultValue));
    }

    public String makeFieldPrompt(String fieldName, String defaultValue) {
        return String.format("%s [default: %s]: ", fieldName, defaultValue);
    }

    private boolean isAffirmative(String input) {
        Objects.requireNonNull(input);
        for (String affirmativeString : affirmativeStrings) {
            if (!input.equalsIgnoreCase(affirmativeString)) continue;
            return true;
        }
        return false;
    }

    private boolean isNegative(String input) {
        Objects.requireNonNull(input);
        for (String negativeString : negativeStrings) {
            if (!input.equalsIgnoreCase(negativeString)) continue;
            return true;
        }
        return false;
    }

    protected boolean promptBoolean(String prompt, Optional<Boolean> defaultValue) throws IOException {
        Objects.requireNonNull(prompt);
        Objects.requireNonNull(defaultValue);
        ConsoleReader reader = this.getReader();
        reader.setPrompt(prompt);
        Boolean value = null;
        boolean prompting = true;
        while (prompting) {
            String input = reader.readLine();
            if (input.isEmpty() && defaultValue.isPresent()) {
                value = (Boolean)defaultValue.get();
                prompting = false;
            }
            if (this.isAffirmative(input)) {
                value = true;
                prompting = false;
            }
            if (this.isNegative(input)) {
                value = false;
                prompting = false;
            }
            if (!prompting) continue;
            reader.println((CharSequence)"Invalid response (true/false)");
        }
        return value;
    }

    protected String promptString(String prompt, Optional<String> defaultValue) throws IOException {
        Objects.requireNonNull(prompt);
        Objects.requireNonNull(defaultValue);
        ConsoleReader reader = this.getReader();
        reader.setPrompt(prompt);
        String value = null;
        boolean prompting = true;
        while (prompting) {
            String input = reader.readLine();
            if (!input.isEmpty()) {
                value = input;
                prompting = false;
                continue;
            }
            if (defaultValue.isPresent()) {
                value = (String)defaultValue.get();
                prompting = false;
                continue;
            }
            reader.println((CharSequence)"Invalid response. Must provide a value.");
        }
        return value;
    }
}

