/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import jline.console.ConsoleReader;
import org.apache.rya.api.client.Install;
import org.apache.rya.shell.SharedShellState;
import org.apache.rya.shell.util.JLinePrompt;
import org.springframework.beans.factory.annotation.Autowired;

public interface InstallPrompt {
    public String promptInstanceName() throws IOException;

    public Install.InstallConfiguration promptInstallConfiguration(String var1) throws IOException;

    public boolean promptVerified(String var1, Install.InstallConfiguration var2) throws IOException;

    @DefaultAnnotation(value={NonNull.class})
    public static class JLineInstallPropmpt
    extends JLinePrompt
    implements InstallPrompt {
        @Autowired
        private SharedShellState sharedShellState;

        @Override
        public String promptInstanceName() throws IOException {
            String prompt = this.makeFieldPrompt("Rya Instance Name", "rya_");
            String instanceName = this.promptString(prompt, (Optional<String>)Optional.of((Object)"rya_"));
            return instanceName;
        }

        @Override
        public Install.InstallConfiguration promptInstallConfiguration(String instanceName) throws IOException {
            Optional<SharedShellState.StorageType> storageType = this.sharedShellState.getShellState().getStorageType();
            Preconditions.checkState((boolean)storageType.isPresent(), (Object)"The shell must be connected to a storage to use the install prompt.");
            switch ((SharedShellState.StorageType)((Object)this.sharedShellState.getShellState().getStorageType().get())) {
                case ACCUMULO: {
                    return this.promptAccumuloConfig(instanceName);
                }
                case MONGO: {
                    return this.promptMongoConfig(instanceName);
                }
            }
            throw new IllegalStateException("Unsupported storage type: " + storageType.get());
        }

        @Override
        public boolean promptVerified(String instanceName, Install.InstallConfiguration installConfig) throws IOException {
            Optional<SharedShellState.StorageType> storageType = this.sharedShellState.getShellState().getStorageType();
            Preconditions.checkState((boolean)storageType.isPresent(), (Object)"The shell must be connected to a storage to use the install prompt.");
            switch ((SharedShellState.StorageType)((Object)this.sharedShellState.getShellState().getStorageType().get())) {
                case ACCUMULO: {
                    return this.promptAccumuloVerified(instanceName, installConfig);
                }
                case MONGO: {
                    return this.promptMongoVerified(instanceName, installConfig);
                }
            }
            throw new IllegalStateException("Unsupported storage type: " + storageType.get());
        }

        private Install.InstallConfiguration promptAccumuloConfig(String instanceName) throws IOException {
            boolean useFluoApp;
            Objects.requireNonNull(instanceName);
            Install.InstallConfiguration.Builder builder = Install.InstallConfiguration.builder();
            String prompt = this.makeFieldPrompt("Use Shard Balancing (improves streamed input write speeds)", false);
            boolean enableTableHashPrefix = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)false));
            builder.setEnableTableHashPrefix(enableTableHashPrefix);
            prompt = this.makeFieldPrompt("Use Entity Centric Indexing", true);
            boolean enableEntityCentricIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnableEntityCentricIndex(enableEntityCentricIndexing);
            prompt = this.makeFieldPrompt("Use Free Text Indexing", true);
            boolean enableFreeTextIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnableFreeTextIndex(enableFreeTextIndexing);
            prompt = this.makeFieldPrompt("Use Temporal Indexing", true);
            boolean useTemporalIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnableTemporalIndex(useTemporalIndexing);
            prompt = this.makeFieldPrompt("Use Precomputed Join Indexing", true);
            boolean enablePCJIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnablePcjIndex(enablePCJIndexing);
            if (enablePCJIndexing && (useFluoApp = this.promptBoolean("Use a Fluo application to update the PCJ Index? (y/n) ", (Optional<Boolean>)Optional.absent()))) {
                prompt = this.makeFieldPrompt("PCJ Updater Fluo Application Name (must be initialized)", instanceName + "pcj_updater");
                String fluoAppName = this.promptString(prompt, (Optional<String>)Optional.of((Object)(instanceName + "pcj_updater")));
                builder.setFluoPcjAppName(fluoAppName);
            }
            return builder.build();
        }

        private boolean promptAccumuloVerified(String instanceName, Install.InstallConfiguration installConfig) throws IOException {
            Objects.requireNonNull(instanceName);
            Objects.requireNonNull(installConfig);
            ConsoleReader reader = this.getReader();
            reader.println();
            reader.println((CharSequence)"A Rya instance will be installed using the following values:");
            reader.println((CharSequence)("   Instance Name: " + instanceName));
            reader.println((CharSequence)("   Use Shard Balancing: " + installConfig.isTableHashPrefixEnabled()));
            reader.println((CharSequence)("   Use Entity Centric Indexing: " + installConfig.isEntityCentrixIndexEnabled()));
            reader.println((CharSequence)("   Use Free Text Indexing: " + installConfig.isFreeTextIndexEnabled()));
            reader.println((CharSequence)("   Use Temporal Indexing: " + installConfig.isTemporalIndexEnabled()));
            reader.println((CharSequence)("   Use Precomputed Join Indexing: " + installConfig.isPcjIndexEnabled()));
            if (installConfig.isPcjIndexEnabled()) {
                if (installConfig.getFluoPcjAppName().isPresent()) {
                    reader.println((CharSequence)("   PCJ Updater Fluo Application Name: " + (String)installConfig.getFluoPcjAppName().get()));
                } else {
                    reader.println((CharSequence)"   Not using a PCJ Updater Fluo Application");
                }
            }
            reader.println((CharSequence)"");
            return this.promptBoolean("Continue with the install? (y/n) ", (Optional<Boolean>)Optional.absent());
        }

        private Install.InstallConfiguration promptMongoConfig(String instanceName) throws IOException {
            Objects.requireNonNull(instanceName);
            Install.InstallConfiguration.Builder builder = Install.InstallConfiguration.builder();
            String prompt = this.makeFieldPrompt("Use Free Text Indexing", true);
            boolean enableFreeTextIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnableFreeTextIndex(enableFreeTextIndexing);
            prompt = this.makeFieldPrompt("Use Temporal Indexing", true);
            boolean useTemporalIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnableTemporalIndex(useTemporalIndexing);
            prompt = this.makeFieldPrompt("Use PCJ Indexing", true);
            boolean usePcjIndexing = this.promptBoolean(prompt, (Optional<Boolean>)Optional.of((Object)true));
            builder.setEnablePcjIndex(usePcjIndexing);
            return builder.build();
        }

        private boolean promptMongoVerified(String instanceName, Install.InstallConfiguration installConfig) throws IOException {
            Objects.requireNonNull(instanceName);
            Objects.requireNonNull(installConfig);
            ConsoleReader reader = this.getReader();
            reader.println();
            reader.println((CharSequence)"A Rya instance will be installed using the following values:");
            reader.println((CharSequence)("   Instance Name: " + instanceName));
            reader.println((CharSequence)("   Use Free Text Indexing: " + installConfig.isFreeTextIndexEnabled()));
            reader.println((CharSequence)("   Use Temporal Indexing: " + installConfig.isTemporalIndexEnabled()));
            reader.println((CharSequence)("   Use PCJ Indexing: " + installConfig.isPcjIndexEnabled()));
            reader.println((CharSequence)"");
            return this.promptBoolean("Continue with the install? (y/n) ", (Optional<Boolean>)Optional.absent());
        }
    }
}

