/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import com.google.common.base.Optional;
import com.mongodb.MongoClient;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.rya.api.client.RyaClient;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.streams.api.RyaStreamsClient;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class SharedShellState {
    private final ReentrantLock lock = new ReentrantLock();
    private ShellState shellState = ShellState.builder().setConnectionState(ConnectionState.DISCONNECTED).build();

    public ShellState getShellState() {
        this.lock.lock();
        try {
            ShellState shellState = this.shellState;
            return shellState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectedToAccumulo(AccumuloConnectionDetails connectionDetails, RyaClient connectedCommands) throws IllegalStateException {
        Objects.requireNonNull(connectionDetails);
        Objects.requireNonNull(connectedCommands);
        this.lock.lock();
        try {
            if (this.shellState.getConnectionState() != ConnectionState.DISCONNECTED) {
                throw new IllegalStateException("You must clear the old connection state before you may set a new connection state.");
            }
            this.shellState = ShellState.builder().setConnectionState(ConnectionState.CONNECTED_TO_STORAGE).setAccumuloDetails(connectionDetails).setConnectedCommands(connectedCommands).build();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectedToMongo(MongoConnectionDetails connectionDetails, RyaClient connectedCommands) throws IllegalStateException {
        Objects.requireNonNull(connectionDetails);
        Objects.requireNonNull(connectedCommands);
        this.lock.lock();
        try {
            if (this.shellState.getConnectionState() != ConnectionState.DISCONNECTED) {
                throw new IllegalStateException("You must clear the old connection state before you may set a new connection state.");
            }
            this.shellState = ShellState.builder().setConnectionState(ConnectionState.CONNECTED_TO_STORAGE).setMongoDetails(connectionDetails).setConnectedCommands(connectedCommands).build();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectedToInstance(String instanceName) throws IllegalStateException {
        Objects.requireNonNull(instanceName);
        this.lock.lock();
        try {
            if (this.shellState.getConnectionState() == ConnectionState.DISCONNECTED) {
                throw new IllegalStateException("You can not set a Rya Instance Name before connecting to a Rya Storage.");
            }
            this.shellState = ShellState.builder(this.shellState).setConnectionState(ConnectionState.CONNECTED_TO_INSTANCE).setRyaInstanceName(instanceName).build();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectedToRyaStreams(RyaStreamsClient ryaStreamsCommands) {
        Objects.requireNonNull(ryaStreamsCommands);
        this.lock.lock();
        try {
            if (this.shellState.getConnectionState() != ConnectionState.CONNECTED_TO_INSTANCE) {
                throw new IllegalStateException("You can not set the connected Rya Streams Client before connected to a Rya Instance.");
            }
            this.shellState = ShellState.builder(this.shellState).setRyaStreamsCommands(ryaStreamsCommands).build();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disconnected() {
        this.lock.lock();
        try {
            this.shellState = ShellState.builder().setConnectionState(ConnectionState.DISCONNECTED).build();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Immutable
    @DefaultAnnotation(value={NonNull.class})
    public static final class ShellState {
        private final ConnectionState connectionState;
        private final Optional<StorageType> storageType;
        private final Optional<AccumuloConnectionDetails> accumuloDetails;
        private final Optional<MongoConnectionDetails> mongoDetails;
        private final Optional<MongoClient> mongoAdminClient;
        private final Optional<RyaClient> connectedCommands;
        private final Optional<RyaStreamsClient> ryaStreamsCommands;
        private final Optional<String> instanceName;

        private ShellState(ConnectionState connectionState, Optional<StorageType> storageType, Optional<AccumuloConnectionDetails> accumuloDetails, Optional<MongoConnectionDetails> mongoDetails, Optional<MongoClient> mongoAdminClient, Optional<RyaClient> connectedCommands, Optional<String> instanceName, Optional<RyaStreamsClient> ryaStreamsCommands) {
            this.connectionState = Objects.requireNonNull(connectionState);
            this.storageType = Objects.requireNonNull(storageType);
            this.accumuloDetails = Objects.requireNonNull(accumuloDetails);
            this.mongoDetails = Objects.requireNonNull(mongoDetails);
            this.mongoAdminClient = Objects.requireNonNull(mongoAdminClient);
            this.connectedCommands = Objects.requireNonNull(connectedCommands);
            this.instanceName = Objects.requireNonNull(instanceName);
            this.ryaStreamsCommands = Objects.requireNonNull(ryaStreamsCommands);
        }

        public ConnectionState getConnectionState() {
            return this.connectionState;
        }

        public Optional<StorageType> getStorageType() {
            return this.storageType;
        }

        public Optional<AccumuloConnectionDetails> getAccumuloDetails() {
            return this.accumuloDetails;
        }

        public Optional<MongoConnectionDetails> getMongoDetails() {
            return this.mongoDetails;
        }

        public Optional<MongoClient> getMongoAdminClient() {
            return this.mongoAdminClient;
        }

        public Optional<RyaClient> getConnectedCommands() {
            return this.connectedCommands;
        }

        public Optional<RyaStreamsClient> getRyaStreamsCommands() {
            return this.ryaStreamsCommands;
        }

        public Optional<String> getRyaInstanceName() {
            return this.instanceName;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.connectionState, this.accumuloDetails, this.connectedCommands, this.instanceName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ShellState) {
                ShellState state = (ShellState)obj;
                return Objects.equals((Object)this.connectionState, (Object)state.connectionState) && Objects.equals(this.accumuloDetails, state.accumuloDetails) && Objects.equals(this.connectedCommands, state.connectedCommands) && Objects.equals(this.instanceName, state.instanceName);
            }
            return false;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(ShellState shellState) {
            return new Builder(shellState);
        }

        @DefaultAnnotation(value={NonNull.class})
        public static class Builder {
            private ConnectionState connectionState;
            private StorageType storageType;
            private AccumuloConnectionDetails accumuloDetails;
            private MongoConnectionDetails mongoDetails;
            private MongoClient mongoAdminClient;
            private RyaClient connectedCommands;
            private RyaStreamsClient ryaStreamsCommands;
            private String instanceName;

            public Builder() {
            }

            public Builder(ShellState shellState) {
                this.connectionState = shellState.getConnectionState();
                this.storageType = (StorageType)((Object)shellState.getStorageType().orNull());
                this.accumuloDetails = (AccumuloConnectionDetails)shellState.getAccumuloDetails().orNull();
                this.mongoDetails = (MongoConnectionDetails)shellState.getMongoDetails().orNull();
                this.mongoAdminClient = (MongoClient)shellState.getMongoAdminClient().orNull();
                this.connectedCommands = (RyaClient)shellState.getConnectedCommands().orNull();
                this.ryaStreamsCommands = (RyaStreamsClient)shellState.getRyaStreamsCommands().orNull();
                this.instanceName = (String)shellState.getRyaInstanceName().orNull();
            }

            public Builder setConnectionState(@Nullable ConnectionState connectionState) {
                this.connectionState = connectionState;
                return this;
            }

            public Builder setAccumuloDetails(@Nullable AccumuloConnectionDetails accumuloDetails) {
                if (accumuloDetails != null) {
                    this.storageType = StorageType.ACCUMULO;
                    this.mongoDetails = null;
                }
                this.accumuloDetails = accumuloDetails;
                return this;
            }

            public Builder setMongoDetails(@Nullable MongoConnectionDetails mongoDetails) {
                if (mongoDetails != null) {
                    this.storageType = StorageType.MONGO;
                    this.accumuloDetails = null;
                }
                this.mongoDetails = mongoDetails;
                return this;
            }

            public Builder setMongoAdminClient(@Nullable MongoClient mongoAdminClient) {
                this.mongoAdminClient = mongoAdminClient;
                return this;
            }

            public Builder setConnectedCommands(@Nullable RyaClient connectedCommands) {
                this.connectedCommands = connectedCommands;
                return this;
            }

            public Builder setRyaStreamsCommands(@Nullable RyaStreamsClient ryaStreamsCommands) {
                this.ryaStreamsCommands = ryaStreamsCommands;
                return this;
            }

            public Builder setRyaInstanceName(@Nullable String instanceName) {
                this.instanceName = instanceName;
                return this;
            }

            public ShellState build() {
                return new ShellState(this.connectionState, Optional.fromNullable((Object)((Object)this.storageType)), Optional.fromNullable((Object)this.accumuloDetails), Optional.fromNullable((Object)this.mongoDetails), Optional.fromNullable((Object)this.mongoAdminClient), Optional.fromNullable((Object)this.connectedCommands), Optional.fromNullable((Object)this.instanceName), Optional.fromNullable((Object)this.ryaStreamsCommands));
            }
        }
    }

    public static enum StorageType {
        ACCUMULO,
        MONGO;

    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTED_TO_STORAGE,
        CONNECTED_TO_INSTANCE;

    }
}

