/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import java.util.Objects;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.shell.SharedShellState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultPromptProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class RyaPromptProvider
extends DefaultPromptProvider {
    private final SharedShellState sharedState;

    @Autowired
    public RyaPromptProvider(SharedShellState sharedState) {
        this.sharedState = Objects.requireNonNull(sharedState);
    }

    public String getPrompt() {
        SharedShellState.ShellState state = this.sharedState.getShellState();
        String storageName = "unknown";
        if (state.getStorageType().isPresent()) {
            if (state.getStorageType().get() == SharedShellState.StorageType.ACCUMULO) {
                storageName = ((AccumuloConnectionDetails)state.getAccumuloDetails().get()).getInstanceName();
            } else if (state.getStorageType().get() == SharedShellState.StorageType.MONGO) {
                storageName = ((MongoConnectionDetails)state.getMongoDetails().get()).getHostname();
            } else {
                throw new IllegalStateException("Missing or unknown storage type.");
            }
        }
        switch (state.getConnectionState()) {
            case DISCONNECTED: {
                return "rya> ";
            }
            case CONNECTED_TO_STORAGE: {
                return String.format("rya/%s> ", storageName);
            }
            case CONNECTED_TO_INSTANCE: {
                return String.format("rya/%s:%s> ", storageName, state.getRyaInstanceName().or((Object)"unknown"));
            }
        }
        return "rya> ";
    }
}

