/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.rya.api.client.InstanceExists;
import org.apache.rya.api.client.RyaClient;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.client.accumulo.AccumuloConnectionDetails;
import org.apache.rya.api.client.accumulo.AccumuloRyaClientFactory;
import org.apache.rya.api.client.mongo.MongoConnectionDetails;
import org.apache.rya.api.client.mongo.MongoRyaClientFactory;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.shell.SharedShellState;
import org.apache.rya.shell.util.ConnectorFactory;
import org.apache.rya.shell.util.PasswordPrompt;
import org.apache.rya.streams.api.RyaStreamsClient;
import org.apache.rya.streams.kafka.KafkaRyaStreamsClientFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RyaConnectionCommands
implements CommandMarker {
    public static final String PRINT_CONNECTION_DETAILS_CMD = "print-connection-details";
    public static final String CONNECT_ACCUMULO_CMD = "connect-accumulo";
    public static final String CONNECT_MONGO_CMD = "connect-mongo";
    public static final String CONNECT_INSTANCE_CMD = "connect-rya";
    public static final String DISCONNECT_COMMAND_NAME_CMD = "disconnect";
    private final SharedShellState sharedState;
    private final PasswordPrompt passwordPrompt;

    @Autowired
    public RyaConnectionCommands(SharedShellState state, PasswordPrompt passwordPrompt) {
        this.sharedState = Objects.requireNonNull(state);
        this.passwordPrompt = Objects.requireNonNull(passwordPrompt);
    }

    @CliAvailabilityIndicator(value={"print-connection-details"})
    public boolean isPrintConnectionDetailsAvailable() {
        return true;
    }

    @CliAvailabilityIndicator(value={"connect-accumulo", "connect-mongo"})
    public boolean areConnectCommandsAvailable() {
        return this.sharedState.getShellState().getConnectionState() == SharedShellState.ConnectionState.DISCONNECTED;
    }

    @CliAvailabilityIndicator(value={"connect-rya"})
    public boolean isConnectToInstanceAvailable() {
        switch (this.sharedState.getShellState().getConnectionState()) {
            case CONNECTED_TO_STORAGE: 
            case CONNECTED_TO_INSTANCE: {
                return true;
            }
        }
        return false;
    }

    @CliAvailabilityIndicator(value={"disconnect"})
    public boolean isDisconnectAvailable() {
        return this.sharedState.getShellState().getConnectionState() != SharedShellState.ConnectionState.DISCONNECTED;
    }

    @CliCommand(value={"print-connection-details"}, help="Print information about the Shell's Rya storage connection.")
    public String printConnectionDetails() {
        com.google.common.base.Optional<SharedShellState.StorageType> storageType = this.sharedState.getShellState().getStorageType();
        if (!storageType.isPresent()) {
            return "The shell is not connected to anything.";
        }
        switch ((SharedShellState.StorageType)((Object)storageType.get())) {
            case ACCUMULO: {
                AccumuloConnectionDetails accDetails = (AccumuloConnectionDetails)this.sharedState.getShellState().getAccumuloDetails().get();
                return "The shell is connected to an instance of Accumulo using the following parameters:\n    Username: " + accDetails.getUsername() + "\n    Instance Name: " + accDetails.getInstanceName() + "\n    Zookeepers: " + accDetails.getZookeepers();
            }
            case MONGO: {
                MongoConnectionDetails mongoDetails = (MongoConnectionDetails)this.sharedState.getShellState().getMongoDetails().get();
                StringBuilder message = new StringBuilder().append("The shell is connected to an instance of MongoDB using the following parameters:\n").append("    Hostname: " + mongoDetails.getHostname() + "\n").append("    Port: " + mongoDetails.getPort() + "\n");
                if (mongoDetails.getUsername().isPresent()) {
                    message.append("    Username: " + (String)mongoDetails.getUsername().get() + "\n");
                }
                return message.toString();
            }
        }
        throw new RuntimeException("Unrecognized StorageType: " + storageType.get());
    }

    @CliCommand(value={"connect-accumulo"}, help="Connect the shell to an instance of Accumulo.")
    public String connectToAccumulo(@CliOption(key={"username"}, mandatory=true, help="The username that will be used to connect to Accummulo.") String username, @CliOption(key={"instanceName"}, mandatory=true, help="The name of the Accumulo instance that will be connected to.") String instanceName, @CliOption(key={"zookeepers"}, mandatory=true, help="A comma delimited list of zookeeper server hostnames.") String zookeepers) {
        try {
            char[] password = this.passwordPrompt.getPassword();
            Connector connector = new ConnectorFactory().connect(username, CharBuffer.wrap(password), instanceName, zookeepers);
            AccumuloConnectionDetails accumuloDetails = new AccumuloConnectionDetails(username, password, instanceName, zookeepers);
            RyaClient commands = AccumuloRyaClientFactory.build((AccumuloConnectionDetails)accumuloDetails, (Connector)connector);
            this.sharedState.connectedToAccumulo(accumuloDetails, commands);
        }
        catch (IOException | AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException("Could not connect to Accumulo. Reason: " + e.getMessage(), e);
        }
        return "Connected. You must select a Rya instance to interact with next.";
    }

    @CliCommand(value={"connect-mongo"}, help="Connect the shell to an instance of MongoDB.")
    public String connectToMongo(@CliOption(key={"username"}, mandatory=false, help="The username that will be used to connect to MongoDB when performing administrative tasks.") String username, @CliOption(key={"hostname"}, mandatory=true, help="The hostname of the MongoDB that will be connected to.") String hostname, @CliOption(key={"port"}, mandatory=true, help="The port of the MongoDB that will be connected to.") String port) {
        try {
            char[] password = null;
            if (username != null) {
                password = this.passwordPrompt.getPassword();
            }
            MongoConnectionDetails connectionDetails = new MongoConnectionDetails(hostname, Integer.parseInt(port), Optional.ofNullable(username), Optional.ofNullable(password));
            final MongoClient adminClient = new MongoClient(hostname, Integer.parseInt(port));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    adminClient.close();
                }
            });
            try {
                adminClient.getConnectPoint();
            }
            catch (MongoException e) {
                adminClient.close();
                throw e;
            }
            RyaClient ryaClient = MongoRyaClientFactory.build((MongoConnectionDetails)connectionDetails, (MongoClient)adminClient);
            this.sharedState.connectedToMongo(connectionDetails, ryaClient);
        }
        catch (MongoException | IOException e) {
            throw new RuntimeException("Could not connection to MongoDB. Reason: " + e.getMessage(), e);
        }
        return "Connected. You must select a Rya instance to interact with next.";
    }

    @CliCommand(value={"connect-rya"}, help="Connect to a specific Rya instance")
    public void connectToInstance(@CliOption(key={"instance"}, mandatory=true, help="The name of the Rya instance the shell will interact with.") String ryaInstance) {
        RyaClient ryaClient = (RyaClient)this.sharedState.getShellState().getConnectedCommands().get();
        try {
            com.google.common.base.Optional streamsDetails;
            InstanceExists instanceExists = ryaClient.getInstanceExists();
            if (!instanceExists.exists(ryaInstance)) {
                throw new RuntimeException(String.format("'%s' does not match an existing Rya instance.", ryaInstance));
            }
            this.sharedState.connectedToInstance(ryaInstance);
            com.google.common.base.Optional ryaDetails = ryaClient.getGetInstanceDetails().getDetails(ryaInstance);
            if (ryaDetails.isPresent() && (streamsDetails = ((RyaDetails)ryaDetails.get()).getRyaStreamsDetails()).isPresent()) {
                String kafkaHostname = ((RyaDetails.RyaStreamsDetails)streamsDetails.get()).getHostname();
                int kafkaPort = ((RyaDetails.RyaStreamsDetails)streamsDetails.get()).getPort();
                RyaStreamsClient streamsClient = KafkaRyaStreamsClientFactory.make((String)ryaInstance, (String)kafkaHostname, (int)kafkaPort);
                this.sharedState.connectedToRyaStreams(streamsClient);
            }
        }
        catch (RyaClientException e) {
            throw new RuntimeException("Could not connect to Rya instance. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"disconnect"}, help="Disconnect the shell's Rya storage connection (Accumulo).")
    public void disconnect() {
        com.google.common.base.Optional<RyaStreamsClient> streamsClient;
        SharedShellState.ShellState shellState = this.sharedState.getShellState();
        com.google.common.base.Optional<MongoClient> mongoAdminClient = shellState.getMongoAdminClient();
        if (mongoAdminClient.isPresent()) {
            ((MongoClient)mongoAdminClient.get()).close();
        }
        if ((streamsClient = shellState.getRyaStreamsCommands()).isPresent()) {
            try {
                ((RyaStreamsClient)streamsClient.get()).close();
            }
            catch (Exception e) {
                System.err.print("Could not close the RyaStreamsClient.");
                e.printStackTrace();
            }
        }
        this.sharedState.disconnected();
    }
}

