/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.rya.api.client.RyaClient;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.shell.SharedShellState;
import org.apache.rya.shell.util.ConsolePrinter;
import org.apache.rya.shell.util.SparqlPrompt;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RyaCommands
implements CommandMarker {
    private static final Logger log = LoggerFactory.getLogger(RyaCommands.class);
    public static final String LOAD_DATA_CMD = "load-data";
    public static final String SPARQL_QUERY_CMD = "sparql-query";
    private final SharedShellState state;
    private final SparqlPrompt sparqlPrompt;
    private final ConsolePrinter consolePrinter;

    @Autowired
    public RyaCommands(SharedShellState state, SparqlPrompt sparqlPrompt, ConsolePrinter consolePrinter) {
        this.state = Objects.requireNonNull(state);
        this.sparqlPrompt = Objects.requireNonNull(sparqlPrompt);
        this.consolePrinter = Objects.requireNonNull(consolePrinter);
    }

    @CliAvailabilityIndicator(value={"load-data", "sparql-query"})
    public boolean areInstanceCommandsAvailable() {
        switch (this.state.getShellState().getConnectionState()) {
            case CONNECTED_TO_INSTANCE: {
                return true;
            }
        }
        return false;
    }

    @CliCommand(value={"load-data"}, help="Loads RDF Statement data from a local file to the connected Rya instance.")
    public String loadData(@CliOption(key={"file"}, mandatory=true, help="A local file containing RDF Statements that is to be loaded.") String file, @CliOption(key={"format"}, mandatory=false, help="The format of the supplied RDF Statements file. [RDF/XML, N-Triples, Turtle, N3, TriX, TriG, BinaryRDF, N-Quads, JSON-LD, RDF/JSON, RDFa]") String format) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        Optional<String> ryaInstanceName = shellState.getRyaInstanceName();
        try {
            long start = System.currentTimeMillis();
            String userHome = FilenameUtils.separatorsToUnix((String)System.getProperty("user.home"));
            Path rootedFile = Paths.get(file.replaceFirst("^~", userHome), new String[0]);
            RDFFormat rdfFormat = null;
            if (format != null) {
                rdfFormat = RDFFormat.valueOf((String)format);
                if (rdfFormat == null) {
                    throw new RuntimeException("Unsupported RDF Statement data input format: " + format);
                }
            } else if (rdfFormat == null) {
                rdfFormat = RDFFormat.forFileName((String)rootedFile.getFileName().toString());
                if (rdfFormat == null) {
                    throw new RuntimeException("Unable to detect RDF Statement data input format for file: " + rootedFile);
                }
                this.consolePrinter.println("Detected RDF Format: " + rdfFormat);
                this.consolePrinter.flush();
            }
            commands.getLoadStatementsFile().loadStatements((String)ryaInstanceName.get(), rootedFile, rdfFormat);
            String seconds = new DecimalFormat("0.0##").format((double)(System.currentTimeMillis() - start) / 1000.0);
            return "Loaded the file: '" + file + "' successfully in " + seconds + " seconds.";
        }
        catch (IOException | RyaClientException e) {
            log.error("Error", e);
            throw new RuntimeException("Can not load the RDF Statement data. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"sparql-query"}, help="Executes the provided SPARQL Query on the connected Rya instance.")
    public String sparqlQuery(@CliOption(key={"file"}, mandatory=false, help="A local file containing the SPARQL Query that is to be read and executed.") String file) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        Optional<String> ryaInstanceName = shellState.getRyaInstanceName();
        try {
            String sparqlQuery;
            if (file != null) {
                sparqlQuery = new String(Files.readAllBytes(new File(file).toPath()), StandardCharsets.UTF_8);
                this.consolePrinter.println("Loaded Query:");
                this.consolePrinter.println(sparqlQuery);
            } else {
                Optional<String> sparqlQueryOpt = this.sparqlPrompt.getSparql();
                if (sparqlQueryOpt.isPresent()) {
                    sparqlQuery = (String)sparqlQueryOpt.get();
                } else {
                    return "";
                }
            }
            this.consolePrinter.println("Executing Query...");
            this.consolePrinter.flush();
            return commands.getExecuteSparqlQuery().executeSparqlQuery((String)ryaInstanceName.get(), sparqlQuery);
        }
        catch (IOException | RyaClientException e) {
            log.error("Error", e);
            throw new RuntimeException("Can not execute the SPARQL Query. Reason: " + e.getMessage(), e);
        }
    }
}

