/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.plugin.support.DefaultBannerProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class RyaBannerProvider
extends DefaultBannerProvider
implements CommandMarker {
    private final Logger log = LoggerFactory.getLogger(RyaBannerProvider.class);
    private static final String BANNER = " _____                _____ _          _ _ \n|  __ \\              / ____| |        | | |\n| |__) |   _  __ _  | (___ | |__   ___| | |\n|  _  / | | |/ _` |  \\___ \\| '_ \\ / _ \\ | |\n| | \\ \\ |_| | (_| |  ____) | | | |  __/ | |\n|_|  \\_\\__, |\\__,_| |_____/|_| |_|\\___|_|_|\n        __/ |                              \n       |___/                               ";
    private String version = null;

    public String getBanner() {
        return " _____                _____ _          _ _ \n|  __ \\              / ____| |        | | |\n| |__) |   _  __ _  | (___ | |__   ___| | |\n|  _  / | | |/ _` |  \\___ \\| '_ \\ / _ \\ | |\n| | \\ \\ |_| | (_| |  ____) | | | |  __/ | |\n|_|  \\_\\__, |\\__,_| |_____/|_| |_|\\___|_|_|\n        __/ |                              \n       |___/                               \n" + this.getVersion() + "\n";
    }

    public String getWelcomeMessage() {
        return "Welcome to the Rya Shell.\n\nExecute one of the connect commands to start interacting with an instance of Rya.\nYou may press tab at any time to see which of the commands are available.";
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.loadVersion();
        }
        return this.version;
    }

    private String loadVersion() {
        String className = ((Object)((Object)this)).getClass().getSimpleName() + ".class";
        String classPath = ((Object)((Object)this)).getClass().getResource(className).toString();
        try {
            URL classUrl = new URL(classPath);
            JarURLConnection jarConnection = (JarURLConnection)classUrl.openConnection();
            Manifest manifest = jarConnection.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Implementation-Version");
        }
        catch (IOException e) {
            this.log.error("Could not load the application's version from it's manifest.", (Throwable)e);
            return "UNKNOWN";
        }
    }
}

