/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.shell;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.rya.api.client.AddUser;
import org.apache.rya.api.client.CreatePCJ;
import org.apache.rya.api.client.CreatePeriodicPCJ;
import org.apache.rya.api.client.DeletePeriodicPCJ;
import org.apache.rya.api.client.GetInstanceDetails;
import org.apache.rya.api.client.Install;
import org.apache.rya.api.client.InstanceDoesNotExistException;
import org.apache.rya.api.client.ListIncrementalQueries;
import org.apache.rya.api.client.RemoveUser;
import org.apache.rya.api.client.RyaClient;
import org.apache.rya.api.client.RyaClientException;
import org.apache.rya.api.instance.RyaDetails;
import org.apache.rya.shell.SharedShellState;
import org.apache.rya.shell.util.InstallPrompt;
import org.apache.rya.shell.util.InstanceNamesFormatter;
import org.apache.rya.shell.util.RyaDetailsFormatter;
import org.apache.rya.shell.util.SparqlPrompt;
import org.apache.rya.shell.util.UninstallPrompt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RyaAdminCommands
implements CommandMarker {
    public static final String CREATE_PCJ_CMD = "create-pcj";
    public static final String CREATE_PERIODIC_PCJ_CMD = "create-periodic-pcj";
    public static final String DELETE_PCJ_CMD = "delete-pcj";
    public static final String DELETE_PERIODIC_PCJ_CMD = "delete-periodic-pcj";
    public static final String LIST_INCREMENTAL_QUERIES = "list-incremental-queries";
    public static final String PRINT_INSTANCE_DETAILS_CMD = "print-instance-details";
    public static final String INSTALL_CMD = "install";
    public static final String INSTALL_ACCUMULO_PARAMETERS_CMD = "install-with-accumulo-parameters";
    public static final String INSTALL_MONGO_PARAMETERS_CMD = "install-with-mongo-parameters";
    public static final String LIST_INSTANCES_CMD = "list-instances";
    public static final String UNINSTALL_CMD = "uninstall";
    public static final String ADD_USER_CMD = "add-user";
    public static final String REMOVE_USER_CMD = "remove-user";
    private final SharedShellState state;
    private final InstallPrompt installPrompt;
    private final SparqlPrompt sparqlPrompt;
    private final UninstallPrompt uninstallPrompt;

    @Autowired
    public RyaAdminCommands(SharedShellState state, InstallPrompt installPrompt, SparqlPrompt sparqlPrompt, UninstallPrompt uninstallPrompt) {
        this.state = Objects.requireNonNull(state);
        this.installPrompt = Objects.requireNonNull(installPrompt);
        this.sparqlPrompt = Objects.requireNonNull(sparqlPrompt);
        this.uninstallPrompt = Objects.requireNonNull(uninstallPrompt);
    }

    @CliAvailabilityIndicator(value={"list-instances", "install"})
    public boolean areStorageCommandsAvailable() {
        switch (this.state.getShellState().getConnectionState()) {
            case CONNECTED_TO_STORAGE: 
            case CONNECTED_TO_INSTANCE: {
                return true;
            }
        }
        return false;
    }

    @CliAvailabilityIndicator(value={"install-with-accumulo-parameters"})
    public boolean areAccumuloStorageCommandsAvailable() {
        return this.isConnectedToStorageType(SharedShellState.StorageType.ACCUMULO);
    }

    @CliAvailabilityIndicator(value={"install-with-mongo-parameters"})
    public boolean areMongoStorageCommandsAvailable() {
        return this.isConnectedToStorageType(SharedShellState.StorageType.MONGO);
    }

    private boolean isConnectedToStorageType(SharedShellState.StorageType type) {
        Optional<SharedShellState.StorageType> storageType = this.state.getShellState().getStorageType();
        if (storageType.isPresent()) {
            return this.areStorageCommandsAvailable() && storageType.get() == type;
        }
        return false;
    }

    @CliAvailabilityIndicator(value={"print-instance-details", "uninstall"})
    public boolean areInstanceCommandsAvailable() {
        return this.state.getShellState().getConnectionState() == SharedShellState.ConnectionState.CONNECTED_TO_INSTANCE;
    }

    @CliAvailabilityIndicator(value={"add-user", "remove-user"})
    public boolean areUserCommandAvailable() {
        return this.areInstanceCommandsAvailable() && this.state.getShellState().getStorageType().get() == SharedShellState.StorageType.ACCUMULO;
    }

    @CliAvailabilityIndicator(value={"create-pcj", "delete-pcj"})
    public boolean arePCJCommandsAvailable() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        if (shellState.getConnectionState() == SharedShellState.ConnectionState.CONNECTED_TO_INSTANCE) {
            GetInstanceDetails getInstanceDetails = ((RyaClient)shellState.getConnectedCommands().get()).getGetInstanceDetails();
            String ryaInstanceName = (String)this.state.getShellState().getRyaInstanceName().get();
            try {
                Optional instanceDetails = getInstanceDetails.getDetails(ryaInstanceName);
                if (instanceDetails.isPresent()) {
                    return ((RyaDetails)instanceDetails.get()).getPCJIndexDetails().isEnabled();
                }
            }
            catch (RyaClientException e) {
                return false;
            }
        }
        return false;
    }

    @CliAvailabilityIndicator(value={"create-periodic-pcj", "delete-periodic-pcj", "list-incremental-queries"})
    public boolean arePeriodicPCJCommandsAvailable() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        if (shellState.getConnectionState() == SharedShellState.ConnectionState.CONNECTED_TO_INSTANCE && shellState.getStorageType().get() == SharedShellState.StorageType.ACCUMULO) {
            GetInstanceDetails getInstanceDetails = ((RyaClient)shellState.getConnectedCommands().get()).getGetInstanceDetails();
            String ryaInstanceName = (String)this.state.getShellState().getRyaInstanceName().get();
            try {
                Optional instanceDetails = getInstanceDetails.getDetails(ryaInstanceName);
                if (instanceDetails.isPresent()) {
                    return ((RyaDetails)instanceDetails.get()).getPCJIndexDetails().isEnabled();
                }
            }
            catch (RyaClientException e) {
                return false;
            }
        }
        return false;
    }

    @CliCommand(value={"list-instances"}, help="List the names of the installed Rya instances.")
    public String listInstances() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        Optional<String> ryaInstance = shellState.getRyaInstanceName();
        try {
            List instanceNames = commands.getListInstances().listInstances();
            if (instanceNames.isEmpty()) {
                return "There are no Rya instances installed on this storage.";
            }
            Collections.sort(instanceNames);
            InstanceNamesFormatter formatter = new InstanceNamesFormatter();
            String report = ryaInstance.isPresent() ? formatter.format(instanceNames, (String)ryaInstance.get()) : formatter.format(instanceNames);
            return report;
        }
        catch (RyaClientException e) {
            throw new RuntimeException("Can not list the Rya instances. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"install"}, help="Create a new instance of Rya interactively.")
    public String install() {
        RyaClient commands = (RyaClient)this.state.getShellState().getConnectedCommands().get();
        String instanceName = null;
        Install.InstallConfiguration installConfig = null;
        try {
            boolean verified = false;
            while (!verified) {
                instanceName = this.installPrompt.promptInstanceName();
                installConfig = this.installPrompt.promptInstallConfiguration(instanceName);
                verified = this.installPrompt.promptVerified(instanceName, installConfig);
            }
            commands.getInstall().install(instanceName, installConfig);
            return String.format("The Rya instance named '%s' has been installed.", instanceName);
        }
        catch (Install.DuplicateInstanceNameException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' already exists. Try again with a different name.", instanceName), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("Could not install a new instance of Rya. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"install-with-accumulo-parameters"}, help="Create a new Accumulo instance of Rya with command line parameters.")
    public String installWithAccumuloParameters(@CliOption(key={"instanceName"}, mandatory=true, help="The name of the Rya instance to create.") String instanceName, @CliOption(key={"enableTableHashPrefix"}, mandatory=false, help="Use Shard Balancing (improves streamed input write speeds).", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableTableHashPrefix, @CliOption(key={"enableEntityCentricIndex"}, mandatory=false, help="Use Entity Centric Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableEntityCentricIndex, @CliOption(key={"enableFreeTextIndex"}, mandatory=false, help="Use Free Text Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableFreeTextIndex, @CliOption(key={"enableTemporalIndex"}, mandatory=false, help="Use Temporal Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableTemporalIndex, @CliOption(key={"enablePcjIndex"}, mandatory=false, help="Use Precomputed Join (PCJ) Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enablePcjIndex, @CliOption(key={"fluoPcjAppName"}, mandatory=false, help="Fluo Application Name for PCJ Index Updater (fluo app must be initialized and enablePcjIndex=true).") String fluoPcjAppName) {
        RyaClient commands = (RyaClient)this.state.getShellState().getConnectedCommands().get();
        try {
            Install.InstallConfiguration installConfig = Install.InstallConfiguration.builder().setEnableTableHashPrefix(enableTableHashPrefix).setEnableEntityCentricIndex(enableEntityCentricIndex).setEnableFreeTextIndex(enableFreeTextIndex).setEnableTemporalIndex(enableTemporalIndex).setEnablePcjIndex(enablePcjIndex).setFluoPcjAppName(fluoPcjAppName).build();
            if (!this.installPrompt.promptVerified(instanceName, installConfig)) {
                return "Skipping Installation.";
            }
            commands.getInstall().install(instanceName, installConfig);
            return String.format("The Rya instance named '%s' has been installed.", instanceName);
        }
        catch (Install.DuplicateInstanceNameException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' already exists. Try again with a different name.", instanceName), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("Could not install a new instance of Rya. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"install-with-mongo-parameters"}, help="Create a new MongoDB instance of Rya with command line parameters.")
    public String installWithMongoParameters(@CliOption(key={"instanceName"}, mandatory=true, help="The name of the Rya instance to create.") String instanceName, @CliOption(key={"enableFreeTextIndex"}, mandatory=false, help="Use Free Text Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableFreeTextIndex, @CliOption(key={"enableTemporalIndex"}, mandatory=false, help="Use Temporal Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enableTemporalIndex, @CliOption(key={"enablePcjIndex"}, mandatory=false, help="Use Precomputed Join (PCJ) Indexing.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean enablePcjIndex) {
        RyaClient commands = (RyaClient)this.state.getShellState().getConnectedCommands().get();
        try {
            Install.InstallConfiguration installConfig = Install.InstallConfiguration.builder().setEnableFreeTextIndex(enableFreeTextIndex).setEnableTemporalIndex(enableTemporalIndex).setEnablePcjIndex(enablePcjIndex).build();
            if (!this.installPrompt.promptVerified(instanceName, installConfig)) {
                return "Skipping Installation.";
            }
            commands.getInstall().install(instanceName, installConfig);
            return String.format("The Rya instance named '%s' has been installed.", instanceName);
        }
        catch (Install.DuplicateInstanceNameException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' already exists. Try again with a different name.", instanceName), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("Could not install a new instance of Rya. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"print-instance-details"}, help="Print information about how the Rya instance is configured.")
    public String printInstanceDetails() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            Optional details = commands.getGetInstanceDetails().getDetails(ryaInstance);
            if (details.isPresent()) {
                return new RyaDetailsFormatter().format((SharedShellState.StorageType)((Object)shellState.getStorageType().get()), (RyaDetails)details.get());
            }
            return "This instance of Rya does not have a Rya Details table. Consider migrating to a newer version of Rya.";
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("Could not get the instance details. Reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"create-pcj"}, help="Creates and starts the maintenance of a new PCJ using a Fluo application.")
    public String createPcj(@CliOption(key={"exportToRya"}, mandatory=false, help="Indicates that results for the query should be exported to a Rya PCJ table.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean exportToRya, @CliOption(key={"exportToKafka"}, mandatory=false, help="Indicates that results for the query should be exported to a Kafka Topic.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean exportToKafka) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            HashSet<CreatePCJ.ExportStrategy> strategies = new HashSet<CreatePCJ.ExportStrategy>();
            if (exportToRya) {
                strategies.add(CreatePCJ.ExportStrategy.RYA);
            }
            if (exportToKafka) {
                strategies.add(CreatePCJ.ExportStrategy.KAFKA);
            }
            if (strategies.isEmpty()) {
                return "The user must specify at least one export strategy: (--exportToRya, --exportToKafka)";
            }
            Optional<String> sparql = this.sparqlPrompt.getSparql();
            if (sparql.isPresent()) {
                String pcjId = commands.getCreatePCJ().createPCJ(ryaInstance, (String)sparql.get(), strategies);
                return String.format("The PCJ has been created. Its ID is '%s'.", pcjId);
            }
            return "";
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("Could not create the PCJ. Provided reasons: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"delete-pcj"}, help="Deletes and halts maintenance of a PCJ.")
    public String deletePcj(@CliOption(key={"pcjId"}, mandatory=true, help="The ID of the PCJ that will be deleted.") String pcjId) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            commands.getDeletePCJ().deletePCJ(ryaInstance, pcjId);
            return "The PCJ has been deleted.";
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("The PCJ could not be deleted. Provided reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"create-periodic-pcj"}, help="Creates and starts the maintenance of a new Periodic PCJ and registers the associated Periodic Notification with Kafka.")
    public String createPeriodicPcj(@CliOption(key={"topic"}, mandatory=true, help="Kafka topic for registering new PeriodicNotifications.  This topic is monitored by the Periodic Notification Service.") String topic, @CliOption(key={"brokers"}, mandatory=true, help="Comma delimited list of host/port pairs to establish the initial connection to the Kafka cluster.") String brokers) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            Optional<String> sparql = this.sparqlPrompt.getSparql();
            if (sparql.isPresent()) {
                String pcjId = ((CreatePeriodicPCJ)commands.getCreatePeriodicPCJ().get()).createPeriodicPCJ(ryaInstance, (String)sparql.get(), topic, brokers);
                return String.format("The Periodic PCJ has been created. Its ID is '%s'.", pcjId);
            }
            return "";
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("Could not create the Periodic PCJ. Provided reasons: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"delete-periodic-pcj"}, help="Deletes and halts maintenance of a Periodic PCJ.")
    public String deletePeriodicPcj(@CliOption(key={"pcjId"}, mandatory=true, help="The ID of the PCJ that will be deleted.") String pcjId, @CliOption(key={"topic"}, mandatory=true, help="Kafka topic for registering a delete notice to remove a PeriodicNotification from the Periodic Notification Service.") String topic, @CliOption(key={"brokers"}, mandatory=true, help="Comma delimited list of host/port pairs to establish the initial connection to the Kafka cluster.") String brokers) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            ((DeletePeriodicPCJ)commands.getDeletePeriodicPCJ().get()).deletePeriodicPCJ(ryaInstance, pcjId, topic, brokers);
            return "The Periodic PCJ has been deleted.";
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("The Periodic PCJ could not be deleted. Provided reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"list-incremental-queries"}, help="Lists relevant information about all SPARQL queries maintained by the Fluo application.")
    public String listFluoQueries() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            return ((ListIncrementalQueries)commands.getListIncrementalQueries().get()).listIncrementalQueries(ryaInstance);
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("Could not list incremental queries. Provided reasons: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"add-user"}, help="Adds an authorized user to the Rya instance.")
    public void addUser(@CliOption(key={"username"}, mandatory=true, help="The username of the user that will be granted access.") String username) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient ryaClient = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            ((AddUser)ryaClient.getAddUser().get()).addUser(ryaInstance, username);
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("The user's access could not be granted. Provided reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"remove-user"}, help="Removes an authorized user from the Rya instance.")
    public void removeUser(@CliOption(key={"username"}, mandatory=true, help="The username of the user whose access will be revoked.") String username) {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient ryaClient = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstance = (String)shellState.getRyaInstanceName().get();
        try {
            ((RemoveUser)ryaClient.getRemoveUser().get()).removeUser(ryaInstance, username);
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstance), e);
        }
        catch (RyaClientException e) {
            throw new RuntimeException("The user's access could not be revoked. Provided reason: " + e.getMessage(), e);
        }
    }

    @CliCommand(value={"uninstall"}, help="Uninstall an instance of Rya.")
    public String uninstall() {
        SharedShellState.ShellState shellState = this.state.getShellState();
        RyaClient commands = (RyaClient)shellState.getConnectedCommands().get();
        String ryaInstanceName = (String)shellState.getRyaInstanceName().get();
        try {
            if (!this.uninstallPrompt.promptAreYouSure(ryaInstanceName)) {
                return "Cancelled.";
            }
            commands.getUninstall().uninstall(ryaInstanceName);
        }
        catch (InstanceDoesNotExistException e) {
            throw new RuntimeException(String.format("A Rya instance named '%s' does not exist.", ryaInstanceName), e);
        }
        catch (IOException | RyaClientException e) {
            throw new RuntimeException("The Rya instance could not be uninstalled. Provided reason: " + e.getMessage(), e);
        }
        return "The Rya instance named '" + ryaInstanceName + "' has been uninstalled.";
    }
}

