/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.rdftriplestore.provenance.rdf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.rya.rdftriplestore.provenance.rdf.RDFProvenanceModel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class BaseProvenanceModel
implements RDFProvenanceModel {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private static final Resource QUERY_EVENT_TYPE = VF.createIRI("http://rya.com/provenance#QueryEvent");
    private static final IRI AT_TIME_PROPERTY = VF.createIRI("http://www.w3.org/ns/prov#atTime");
    private static final IRI ASSOCIATED_WITH_USER = VF.createIRI("http://rya.com/provenance#associatedWithUser");
    private static final IRI QUERY_TYPE_PROP = VF.createIRI("http://rya.com/provenance#queryType");
    private static final IRI EXECUTED_QUERY_PROPERTY = VF.createIRI("http://rya.com/provenance#executedQuery");
    private static final String QUERY_NAMESPACE = "http://rya.com/provenance#queryEvent";

    @Override
    public List<Statement> getStatementsForQuery(String query, String user, String queryType) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        IRI queryEventResource = VF.createIRI(QUERY_NAMESPACE + UUID.randomUUID().toString());
        Statement queryEventDecl = VF.createStatement((Resource)queryEventResource, RDF.TYPE, (Value)QUERY_EVENT_TYPE);
        statements.add(queryEventDecl);
        Statement queryEventTime = VF.createStatement((Resource)queryEventResource, AT_TIME_PROPERTY, (Value)VF.createLiteral(new Date()));
        statements.add(queryEventTime);
        Statement queryUser = VF.createStatement((Resource)queryEventResource, ASSOCIATED_WITH_USER, (Value)VF.createLiteral(user));
        statements.add(queryUser);
        Statement executedQuery = VF.createStatement((Resource)queryEventResource, EXECUTED_QUERY_PROPERTY, (Value)VF.createLiteral(query));
        statements.add(executedQuery);
        Statement queryTypeStatement = VF.createStatement((Resource)queryEventResource, QUERY_TYPE_PROP, (Value)VF.createLiteral(queryType));
        statements.add(queryTypeStatement);
        return statements;
    }
}

