/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.rdftriplestore.provenance;

import java.util.List;
import org.apache.rya.rdftriplestore.provenance.ProvenanceCollectionException;
import org.apache.rya.rdftriplestore.provenance.ProvenanceCollector;
import org.apache.rya.rdftriplestore.provenance.rdf.BaseProvenanceModel;
import org.apache.rya.rdftriplestore.provenance.rdf.RDFProvenanceModel;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;

public class TriplestoreProvenanceCollector
implements ProvenanceCollector {
    private RDFProvenanceModel provenanceModel;
    private SailRepository provenanceRepo;
    private String user;
    private String queryType;

    public TriplestoreProvenanceCollector(SailRepository repo, String user, String queryType) {
        this.provenanceRepo = repo;
        this.provenanceModel = new BaseProvenanceModel();
        this.user = user;
        this.queryType = queryType;
    }

    @Override
    public void recordQuery(String query) throws ProvenanceCollectionException {
        List<Statement> provenanceTriples = this.provenanceModel.getStatementsForQuery(query, this.user, this.queryType);
        try {
            this.provenanceRepo.getConnection().add(provenanceTriples, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ProvenanceCollectionException(e);
        }
    }
}

