/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.utils;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.rya.prospector.plans.IndexWorkPlan;

public class ProspectorUtils {
    public static final long INDEXED_DATE_SORT_VAL = 999999999999999999L;
    public static final String INDEXED_DATE_FORMAT = "yyyyMMddHHmmsssSSS";

    public static String getReverseIndexDateTime(Date date) {
        Validate.notNull((Object)date);
        String formattedDateString = new SimpleDateFormat(INDEXED_DATE_FORMAT).format(date);
        long diff = 999999999999999999L - Long.valueOf(formattedDateString);
        return Long.toString(diff);
    }

    public static Map<String, IndexWorkPlan> planMap(Collection<IndexWorkPlan> plans) {
        HashMap<String, IndexWorkPlan> planMap = new HashMap<String, IndexWorkPlan>();
        for (IndexWorkPlan plan : plans) {
            planMap.put(plan.getIndexType(), plan);
        }
        return planMap;
    }

    public static void initMRJob(Job job, String table, String outtable, String[] auths) throws AccumuloSecurityException {
        Configuration conf = job.getConfiguration();
        String username = conf.get("username");
        String password = conf.get("password");
        String instance = conf.get("instance");
        String zookeepers = conf.get("zookeepers");
        String mock = conf.get("mock");
        if (Boolean.parseBoolean(mock)) {
            AccumuloInputFormat.setMockInstance((Job)job, (String)instance);
            AccumuloOutputFormat.setMockInstance((Job)job, (String)instance);
        } else if (zookeepers != null) {
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
            AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
        } else {
            throw new IllegalArgumentException("Must specify either mock or zookeepers");
        }
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken(password.getBytes(StandardCharsets.UTF_8)));
        AccumuloInputFormat.setInputTableName((Job)job, (String)table);
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)new Authorizations(auths));
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken(password.getBytes(StandardCharsets.UTF_8)));
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)outtable);
    }

    public static void addMRPerformance(Configuration conf) {
        conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        conf.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        conf.set("io.sort.mb", "256");
        conf.setBoolean("mapred.compress.map.output", true);
        conf.set("mapred.map.output.compression.codec", GzipCodec.class.getName());
    }

    public static Instance instance(Configuration conf) {
        assert (conf != null);
        String instance_str = conf.get("instance");
        String zookeepers = conf.get("zookeepers");
        String mock = conf.get("mock");
        if (Boolean.parseBoolean(mock)) {
            return new MockInstance(instance_str);
        }
        if (zookeepers != null) {
            return new ZooKeeperInstance(instance_str, zookeepers);
        }
        throw new IllegalArgumentException("Must specify either mock or zookeepers");
    }

    public static Connector connector(Instance instance, Configuration conf) throws AccumuloException, AccumuloSecurityException {
        String username = conf.get("username");
        String password = conf.get("password");
        if (instance == null) {
            instance = ProspectorUtils.instance(conf);
        }
        return instance.getConnector(username, (AuthenticationToken)new PasswordToken((CharSequence)password));
    }

    public static void writeMutations(Connector connector, String tableName, Collection<Mutation> mutations) throws TableNotFoundException, MutationsRejectedException {
        BatchWriter bw = connector.createBatchWriter(tableName, 10000L, 10000L, 4);
        for (Mutation mutation : mutations) {
            bw.addMutation(mutation);
        }
        bw.flush();
        bw.close();
    }
}

