/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.utils.ConnectorFactory;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.persist.RdfDAOException;
import org.apache.rya.api.persist.RdfEvalStatsDAO;
import org.apache.rya.prospector.domain.IndexEntry;
import org.apache.rya.prospector.domain.TripleValueType;
import org.apache.rya.prospector.service.ProspectorService;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class ProspectorServiceEvalStatsDAO
implements RdfEvalStatsDAO<RdfCloudTripleStoreConfiguration> {
    private ProspectorService prospectorService;

    public ProspectorServiceEvalStatsDAO() {
    }

    public ProspectorServiceEvalStatsDAO(ProspectorService prospectorService, RdfCloudTripleStoreConfiguration conf) {
        this.prospectorService = prospectorService;
    }

    public ProspectorServiceEvalStatsDAO(Connector connector, RdfCloudTripleStoreConfiguration conf) throws AccumuloException, AccumuloSecurityException {
        this.prospectorService = new ProspectorService(connector, ProspectorServiceEvalStatsDAO.getProspectTableName(conf));
    }

    public static ProspectorServiceEvalStatsDAO make(Configuration config) throws AccumuloException, AccumuloSecurityException {
        Objects.requireNonNull(config);
        AccumuloRdfConfiguration accConfig = new AccumuloRdfConfiguration(config);
        return new ProspectorServiceEvalStatsDAO(ConnectorFactory.connect((AccumuloRdfConfiguration)accConfig), (RdfCloudTripleStoreConfiguration)accConfig);
    }

    public void init() {
        assert (this.prospectorService != null);
    }

    public boolean isInitialized() {
        return this.prospectorService != null;
    }

    public void destroy() {
    }

    public double getCardinality(RdfCloudTripleStoreConfiguration conf, RdfEvalStatsDAO.CARDINALITY_OF card, List<Value> val) throws RdfDAOException {
        assert (conf != null && card != null && val != null);
        String triplePart = null;
        switch (card) {
            case SUBJECT: {
                triplePart = TripleValueType.SUBJECT.getIndexType();
                break;
            }
            case PREDICATE: {
                triplePart = TripleValueType.PREDICATE.getIndexType();
                break;
            }
            case OBJECT: {
                triplePart = TripleValueType.OBJECT.getIndexType();
                break;
            }
            case SUBJECTPREDICATE: {
                triplePart = TripleValueType.SUBJECT_PREDICATE.getIndexType();
                break;
            }
            case SUBJECTOBJECT: {
                triplePart = TripleValueType.SUBJECT_OBJECT.getIndexType();
                break;
            }
            case PREDICATEOBJECT: {
                triplePart = TripleValueType.PREDICATE_OBJECT.getIndexType();
            }
        }
        String[] auths = conf.getAuths();
        ArrayList<String> indexedValues = new ArrayList<String>();
        Iterator<Value> valueIt = val.iterator();
        while (valueIt.hasNext()) {
            indexedValues.add(valueIt.next().stringValue());
        }
        double cardinality = -1.0;
        try {
            List<IndexEntry> entries = this.prospectorService.query(null, "count", triplePart, indexedValues, null, auths);
            if (!entries.isEmpty()) {
                cardinality = entries.iterator().next().getCount().longValue();
            }
        }
        catch (TableNotFoundException e) {
            throw new RdfDAOException((Throwable)e);
        }
        return cardinality;
    }

    public double getCardinality(RdfCloudTripleStoreConfiguration conf, RdfEvalStatsDAO.CARDINALITY_OF card, List<Value> val, Resource context) {
        return this.getCardinality(conf, card, val);
    }

    public void setConf(RdfCloudTripleStoreConfiguration conf) {
    }

    public RdfCloudTripleStoreConfiguration getConf() {
        return null;
    }

    public static String getProspectTableName(RdfCloudTripleStoreConfiguration conf) {
        return conf.getTablePrefix() + "prospects";
    }

    public void setProspectorService(ProspectorService prospectorService) {
        this.prospectorService = prospectorService;
    }
}

