/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.service;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.apache.rya.prospector.domain.IndexEntry;
import org.apache.rya.prospector.plans.IndexWorkPlan;
import org.apache.rya.prospector.plans.IndexWorkPlanManager;
import org.apache.rya.prospector.plans.impl.ServicesBackedIndexWorkPlanManager;
import org.apache.rya.prospector.utils.ProspectorUtils;

public class ProspectorService {
    private final Connector connector;
    private final String tableName;
    private final IndexWorkPlanManager manager = new ServicesBackedIndexWorkPlanManager();
    private final Map<String, IndexWorkPlan> plans;

    public ProspectorService(Connector connector, String tableName) throws AccumuloException, AccumuloSecurityException {
        this.connector = Objects.requireNonNull(connector);
        this.tableName = Objects.requireNonNull(tableName);
        this.plans = ProspectorUtils.planMap(this.manager.getPlans());
        try {
            TableOperations tos = connector.tableOperations();
            if (!tos.exists(tableName)) {
                tos.create(tableName);
            }
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    public Iterator<Long> getProspects(String[] auths) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(this.tableName, new Authorizations(auths));
        scanner.setRange(Range.exact((CharSequence)"metadata"));
        scanner.fetchColumnFamily(new Text("prospectTime"));
        return new ProspectTimestampIterator(scanner.iterator());
    }

    public Iterator<Long> getProspectsInRange(long beginTime, long endTime, String[] auths) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(this.tableName, new Authorizations(auths));
        scanner.setRange(new Range(new Key((CharSequence)"metadata", (CharSequence)"prospectTime", (CharSequence)ProspectorUtils.getReverseIndexDateTime(new Date(endTime)), (CharSequence)"", Long.MAX_VALUE), new Key((CharSequence)"metadata", (CharSequence)"prospectTime", (CharSequence)ProspectorUtils.getReverseIndexDateTime(new Date(beginTime)), (CharSequence)"", 0L)));
        return new ProspectTimestampIterator(scanner.iterator());
    }

    public List<IndexEntry> query(List<Long> prospectTimes, String indexType, String type, List<String> index, String dataType, String[] auths) throws TableNotFoundException {
        assert (indexType != null);
        IndexWorkPlan plan = this.plans.get(indexType);
        assert (plan != null) : "Index Type: ${indexType} does not exist";
        String compositeIndex = plan.getCompositeValue(index);
        return plan.query(this.connector, this.tableName, prospectTimes, type, compositeIndex, dataType, auths);
    }

    private static final class ProspectTimestampIterator
    implements Iterator<Long> {
        private final Iterator<Map.Entry<Key, Value>> it;

        public ProspectTimestampIterator(Iterator<Map.Entry<Key, Value>> it) {
            this.it = Objects.requireNonNull(it);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Long next() {
            return this.it.next().getKey().getTimestamp();
        }
    }
}

