/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.plans.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.prospector.domain.IndexEntry;
import org.apache.rya.prospector.domain.IntermediateProspect;
import org.apache.rya.prospector.domain.TripleValueType;
import org.apache.rya.prospector.plans.IndexWorkPlan;
import org.apache.rya.prospector.utils.CustomEntry;
import org.apache.rya.prospector.utils.ProspectorUtils;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class CountPlan
implements IndexWorkPlan {
    @Override
    public Collection<Map.Entry<IntermediateProspect, LongWritable>> map(RyaStatement ryaStatement) {
        RyaIRI subject = ryaStatement.getSubject();
        RyaIRI predicate = ryaStatement.getPredicate();
        String subjpred = ryaStatement.getSubject().getData() + "\u0000" + ryaStatement.getPredicate().getData();
        String predobj = ryaStatement.getPredicate().getData() + "\u0000" + ryaStatement.getObject().getData();
        String subjobj = ryaStatement.getSubject().getData() + "\u0000" + ryaStatement.getObject().getData();
        RyaType object = ryaStatement.getObject();
        int localIndex = URIUtil.getLocalNameIndex((String)subject.getData());
        String namespace = subject.getData().substring(0, localIndex - 1);
        String visibility = new String(ryaStatement.getColumnVisibility(), StandardCharsets.UTF_8);
        ArrayList<Map.Entry<IntermediateProspect, LongWritable>> entries = new ArrayList<Map.Entry<IntermediateProspect, LongWritable>>(7);
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(subject.getData()).setDataType(URITYPE).setTripleValueType(TripleValueType.SUBJECT).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(predicate.getData()).setDataType(URITYPE).setTripleValueType(TripleValueType.PREDICATE).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(object.getData()).setDataType(object.getDataType().stringValue()).setTripleValueType(TripleValueType.OBJECT).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(subjpred).setDataType(XMLSchema.STRING.toString()).setTripleValueType(TripleValueType.SUBJECT_PREDICATE).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(subjobj).setDataType(XMLSchema.STRING.toString()).setTripleValueType(TripleValueType.SUBJECT_OBJECT).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(predobj).setDataType(XMLSchema.STRING.toString()).setTripleValueType(TripleValueType.PREDICATE_OBJECT).setVisibility(visibility).build(), ONE));
        entries.add(new CustomEntry<IntermediateProspect, LongWritable>(IntermediateProspect.builder().setIndex("count").setData(namespace).setDataType(URITYPE).setTripleValueType(TripleValueType.ENTITY).setVisibility(visibility).build(), ONE));
        return entries;
    }

    @Override
    public Collection<Map.Entry<IntermediateProspect, LongWritable>> combine(IntermediateProspect prospect, Iterable<LongWritable> counts) {
        long sum = 0L;
        for (LongWritable count : counts) {
            sum += count.get();
        }
        return Collections.singleton(new CustomEntry<IntermediateProspect, LongWritable>(prospect, new LongWritable(sum)));
    }

    @Override
    public void reduce(IntermediateProspect prospect, Iterable<LongWritable> counts, Date timestamp, Reducer.Context context) throws IOException, InterruptedException {
        long sum = 0L;
        for (LongWritable count : counts) {
            sum += count.get();
        }
        String indexType = prospect.getTripleValueType().getIndexType();
        if (sum >= 0L || indexType.equals(TripleValueType.PREDICATE.getIndexType())) {
            Mutation m = new Mutation((CharSequence)(indexType + "\u0000" + prospect.getData() + "\u0000" + ProspectorUtils.getReverseIndexDateTime(timestamp)));
            String dataType = prospect.getDataType();
            ColumnVisibility visibility = new ColumnVisibility(prospect.getVisibility());
            Value sumValue = new Value(("" + sum).getBytes(StandardCharsets.UTF_8));
            m.put((CharSequence)"count", (CharSequence)prospect.getDataType(), visibility, timestamp.getTime(), sumValue);
            context.write(null, (Object)m);
        }
    }

    @Override
    public String getIndexType() {
        return "count";
    }

    @Override
    public String getCompositeValue(List<String> indices) {
        Iterator<String> indexIt = indices.iterator();
        String compositeIndex = indexIt.next();
        while (indexIt.hasNext()) {
            String value = indexIt.next();
            compositeIndex = compositeIndex + "\u0000" + value;
        }
        return compositeIndex;
    }

    @Override
    public List<IndexEntry> query(Connector connector, String tableName, List<Long> prospectTimes, String type, String compositeIndex, String dataType, String[] auths) throws TableNotFoundException {
        assert (connector != null && tableName != null && type != null && compositeIndex != null);
        BatchScanner bs = connector.createBatchScanner(tableName, new Authorizations(auths), 4);
        ArrayList<Range> ranges = new ArrayList<Range>();
        int max = 1000;
        if (prospectTimes != null) {
            for (Long prospectTime : prospectTimes) {
                ranges.add(new Range((CharSequence)(type + "\u0000" + compositeIndex + "\u0000" + ProspectorUtils.getReverseIndexDateTime(new Date(prospectTime)))));
            }
        } else {
            max = 1;
            String prefix = type + "\u0000" + compositeIndex + "\u0000";
            ranges.add(new Range((CharSequence)prefix, (CharSequence)(prefix + "\uffdd")));
        }
        bs.setRanges(ranges);
        if (dataType != null) {
            bs.fetchColumn(new Text("count"), new Text(dataType));
        } else {
            bs.fetchColumnFamily(new Text("count"));
        }
        ArrayList<IndexEntry> indexEntries = new ArrayList<IndexEntry>();
        Iterator iter = bs.iterator();
        while (iter.hasNext() && indexEntries.size() <= max) {
            Map.Entry entry = (Map.Entry)iter.next();
            Key k = (Key)entry.getKey();
            Value v = (Value)entry.getValue();
            String[] rowArr = k.getRow().toString().split("\u0000");
            String values = "";
            values = type.equalsIgnoreCase(TripleValueType.SUBJECT_PREDICATE.getIndexType()) || type.equalsIgnoreCase(TripleValueType.SUBJECT_OBJECT.getIndexType()) || type.equalsIgnoreCase(TripleValueType.PREDICATE_OBJECT.getIndexType()) ? rowArr[1] + "\u0000" + rowArr[2] : rowArr[1];
            String entryDataType = k.getColumnQualifier().toString();
            String entryVisibility = k.getColumnVisibility().toString();
            Long entryCount = Long.parseLong(new String(v.get(), StandardCharsets.UTF_8));
            indexEntries.add(IndexEntry.builder().setData(values).setTripleValueType(rowArr[0]).setIndex("count").setDataType(entryDataType).setVisibility(entryVisibility).setCount(entryCount).setTimestamp(k.getTimestamp()).build());
        }
        bs.close();
        return indexEntries;
    }
}

