/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.mr;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.rya.prospector.domain.IntermediateProspect;
import org.apache.rya.prospector.plans.IndexWorkPlan;
import org.apache.rya.prospector.plans.IndexWorkPlanManager;
import org.apache.rya.prospector.plans.impl.ServicesBackedIndexWorkPlanManager;
import org.apache.rya.prospector.utils.ProspectorUtils;

public class ProspectorReducer
extends Reducer<IntermediateProspect, LongWritable, IntermediateProspect, LongWritable> {
    private Date truncatedDate;
    private final IndexWorkPlanManager manager = new ServicesBackedIndexWorkPlanManager();
    private Map<String, IndexWorkPlan> plans;

    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        long now = conf.getLong("DATE", System.currentTimeMillis());
        this.truncatedDate = DateUtils.truncate((Date)new Date(now), (int)12);
        this.plans = ProspectorUtils.planMap(this.manager.getPlans());
    }

    protected void reduce(IntermediateProspect prospect, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        IndexWorkPlan plan = this.plans.get(prospect.getIndex());
        if (plan != null) {
            plan.reduce(prospect, values, this.truncatedDate, context);
        }
    }
}

