/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.mr;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaTripleContext;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;
import org.apache.rya.prospector.domain.IntermediateProspect;
import org.apache.rya.prospector.plans.IndexWorkPlan;
import org.apache.rya.prospector.plans.IndexWorkPlanManager;
import org.apache.rya.prospector.plans.impl.ServicesBackedIndexWorkPlanManager;

public class ProspectorMapper
extends Mapper<Key, Value, IntermediateProspect, LongWritable> {
    private RyaTripleContext ryaContext;
    private final IndexWorkPlanManager manager = new ServicesBackedIndexWorkPlanManager();
    private final Collection<IndexWorkPlan> plans = this.manager.getPlans();

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.ryaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)new AccumuloRdfConfiguration(context.getConfiguration()));
    }

    public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
        RyaStatement ryaStatement = null;
        try {
            ryaStatement = this.ryaContext.deserializeTriple(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO, new TripleRow(row.getRow().getBytes(), row.getColumnFamily().getBytes(), row.getColumnQualifier().getBytes(), Long.valueOf(row.getTimestamp()), row.getColumnVisibility().getBytes(), data.get()));
        }
        catch (TripleRowResolverException tripleRowResolverException) {
            // empty catch block
        }
        if (ryaStatement != null) {
            for (IndexWorkPlan plan : this.plans) {
                Collection<Map.Entry<IntermediateProspect, LongWritable>> coll = plan.map(ryaStatement);
                for (Map.Entry<IntermediateProspect, LongWritable> entry : coll) {
                    context.write((Object)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
    }
}

