/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.mr;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.rya.prospector.domain.IntermediateProspect;
import org.apache.rya.prospector.plans.IndexWorkPlan;
import org.apache.rya.prospector.plans.IndexWorkPlanManager;
import org.apache.rya.prospector.plans.impl.ServicesBackedIndexWorkPlanManager;
import org.apache.rya.prospector.utils.ProspectorUtils;

public class ProspectorCombiner
extends Reducer<IntermediateProspect, LongWritable, IntermediateProspect, LongWritable> {
    private final IndexWorkPlanManager manager = new ServicesBackedIndexWorkPlanManager();
    private Map<String, IndexWorkPlan> plans;

    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.plans = ProspectorUtils.planMap(this.manager.getPlans());
    }

    protected void reduce(IntermediateProspect prospect, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Collection<Map.Entry<IntermediateProspect, LongWritable>> coll;
        IndexWorkPlan plan = this.plans.get(prospect.getIndex());
        if (plan != null && (coll = plan.combine(prospect, values)) != null) {
            for (Map.Entry<IntermediateProspect, LongWritable> entry : coll) {
                context.write((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

