/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.mr;

import java.util.Collections;
import java.util.Date;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.rya.prospector.domain.IntermediateProspect;
import org.apache.rya.prospector.mr.ProspectorCombiner;
import org.apache.rya.prospector.mr.ProspectorMapper;
import org.apache.rya.prospector.mr.ProspectorReducer;
import org.apache.rya.prospector.utils.ProspectorConstants;
import org.apache.rya.prospector.utils.ProspectorUtils;

public class Prospector
extends Configured
implements Tool {
    private static long NOW = System.currentTimeMillis();
    private Date truncatedDate;

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new Prospector(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        int success;
        Configuration conf = this.getConf();
        this.truncatedDate = DateUtils.truncate((Date)new Date(NOW), (int)12);
        Path configurationPath = new Path(args[0]);
        conf.addResource(configurationPath);
        String inTable = conf.get("prospector.intable");
        String outTable = conf.get("prospector.outtable");
        String auths_str = conf.get("prospector.auths");
        assert (inTable != null);
        assert (outTable != null);
        assert (auths_str != null);
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        String[] auths = auths_str.split(",");
        ProspectorUtils.initMRJob(job, inTable, outTable, auths);
        job.getConfiguration().setLong("DATE", NOW);
        String performant = conf.get("performant");
        if (Boolean.parseBoolean(performant)) {
            ProspectorUtils.addMRPerformance(job.getConfiguration());
        }
        job.setMapOutputKeyClass(IntermediateProspect.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setMapperClass(ProspectorMapper.class);
        job.setCombinerClass(ProspectorCombiner.class);
        job.setReducerClass(ProspectorReducer.class);
        job.waitForCompletion(true);
        int n = success = job.isSuccessful() ? 0 : 1;
        if (success == 0) {
            Mutation m = new Mutation((CharSequence)"metadata");
            m.put((CharSequence)"prospectTime", (CharSequence)ProspectorUtils.getReverseIndexDateTime(this.truncatedDate), new ColumnVisibility("U&FOUO"), this.truncatedDate.getTime(), new Value(ProspectorConstants.EMPTY));
            ProspectorUtils.writeMutations(ProspectorUtils.connector(ProspectorUtils.instance(conf), conf), outTable, Collections.singleton(m));
        }
        return success;
    }
}

