/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;

public enum TripleValueType {
    SUBJECT("subject"),
    PREDICATE("predicate"),
    OBJECT("object"),
    ENTITY("entity"),
    SUBJECT_PREDICATE("subjectpredicate"),
    PREDICATE_OBJECT("predicateobject"),
    SUBJECT_OBJECT("subjectobject");

    private final String indexType;
    private static final ImmutableMap<String, TripleValueType> lookup;

    private TripleValueType(String indexType) {
        this.indexType = Objects.requireNonNull(indexType);
    }

    public String getIndexType() {
        return this.indexType;
    }

    public TripleValueType fromIndexType(String indexType) {
        return (TripleValueType)((Object)lookup.get((Object)indexType));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TripleValueType type : TripleValueType.values()) {
            builder.put((Object)type.getIndexType(), (Object)type);
        }
        lookup = builder.build();
    }
}

