/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.rya.prospector.domain.TripleValueType;

public class IntermediateProspect
implements WritableComparable<IntermediateProspect> {
    private String index;
    private String data;
    private String dataType;
    private TripleValueType tripleValueType;
    private String visibility;

    public IntermediateProspect() {
    }

    public IntermediateProspect(String index, String data, String dataType, TripleValueType tripleValueType, String visibility) {
        this.index = index;
        this.data = data;
        this.dataType = dataType;
        this.tripleValueType = tripleValueType;
        this.visibility = visibility;
    }

    public String getIndex() {
        return this.index;
    }

    public String getData() {
        return this.data;
    }

    public String getDataType() {
        return this.dataType;
    }

    public TripleValueType getTripleValueType() {
        return this.tripleValueType;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public int compareTo(IntermediateProspect t) {
        if (!this.index.equals(t.index)) {
            return this.index.compareTo(t.index);
        }
        if (!this.data.equals(t.data)) {
            return this.data.compareTo(t.data);
        }
        if (!this.dataType.equals(t.dataType)) {
            return this.dataType.compareTo(t.dataType);
        }
        if (!this.tripleValueType.equals((Object)t.tripleValueType)) {
            return this.tripleValueType.compareTo(t.tripleValueType);
        }
        if (!this.visibility.equals(t.visibility)) {
            return this.visibility.compareTo(t.visibility);
        }
        return 0;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.index);
        dataOutput.writeUTF(this.data);
        dataOutput.writeUTF(this.dataType);
        dataOutput.writeUTF(this.tripleValueType.name());
        dataOutput.writeUTF(this.visibility);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.index = dataInput.readUTF();
        this.data = dataInput.readUTF();
        this.dataType = dataInput.readUTF();
        this.tripleValueType = TripleValueType.valueOf(dataInput.readUTF());
        this.visibility = dataInput.readUTF();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String index;
        private String data;
        private String dataType;
        private TripleValueType tripleValueType;
        private String visibility;

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setTripleValueType(TripleValueType tripleValueType) {
            this.tripleValueType = tripleValueType;
            return this;
        }

        public Builder setVisibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public IntermediateProspect build() {
            return new IntermediateProspect(this.index, this.data, this.dataType, this.tripleValueType, this.visibility);
        }
    }
}

