/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.prospector.domain;

import java.util.Objects;

public class IndexEntry {
    private final String index;
    private final String data;
    private final String dataType;
    private final String tripleValueType;
    private final String visibility;
    private final Long count;
    private final Long timestamp;

    public IndexEntry(String index, String data, String dataType, String tripleValueType, String visibility, Long count, Long timestamp) {
        this.index = index;
        this.data = data;
        this.dataType = dataType;
        this.tripleValueType = tripleValueType;
        this.visibility = visibility;
        this.count = count;
        this.timestamp = timestamp;
    }

    public String getIndex() {
        return this.index;
    }

    public String getData() {
        return this.data;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getTripleValueType() {
        return this.tripleValueType;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "IndexEntry{index='" + this.index + '\'' + ", data='" + this.data + '\'' + ", dataType='" + this.dataType + '\'' + ", tripleValueType=" + this.tripleValueType + ", visibility='" + this.visibility + '\'' + ", timestamp='" + this.timestamp + '\'' + ", count=" + this.count + '}';
    }

    public int hashCode() {
        return Objects.hash(this.index, this.data, this.dataType, this.tripleValueType, this.visibility, this.count, this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IndexEntry) {
            IndexEntry entry = (IndexEntry)o;
            return Objects.equals(this.index, entry.index) && Objects.equals(this.data, entry.data) && Objects.equals(this.dataType, entry.dataType) && Objects.equals(this.tripleValueType, entry.tripleValueType) && Objects.equals(this.visibility, entry.visibility) && Objects.equals(this.count, entry.count) && Objects.equals(this.timestamp, entry.timestamp);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String index;
        private String data;
        private String dataType;
        private String tripleValueType;
        private String visibility;
        private Long count;
        private Long timestamp;

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setTripleValueType(String tripleValueType) {
            this.tripleValueType = tripleValueType;
            return this;
        }

        public Builder setVisibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder setCount(Long count) {
            this.count = count;
            return this;
        }

        public Builder setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public IndexEntry build() {
            return new IndexEntry(this.index, this.data, this.dataType, this.tripleValueType, this.visibility, this.count, this.timestamp);
        }
    }
}

