/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class TripleEntry
implements WritableComparable<TripleEntry> {
    private Text first;
    private Text second;
    private Text firstPos;
    private Text secondPos;
    private Text keyPos;

    public TripleEntry() {
        this.first = new Text();
        this.second = new Text();
        this.firstPos = new Text();
        this.secondPos = new Text();
        this.keyPos = new Text();
    }

    public TripleEntry(String first, String second, String firstPos, String secondPos, String keyPos) {
        this.first = new Text(first);
        this.second = new Text(second);
        this.firstPos = new Text(firstPos);
        this.secondPos = new Text(secondPos);
        this.keyPos = new Text(keyPos);
    }

    public TripleEntry(Text first, Text second, Text firstPos, Text secondPos, Text keyPos) {
        this.first = first;
        this.second = second;
        this.firstPos = firstPos;
        this.secondPos = secondPos;
        this.keyPos = keyPos;
    }

    public void setEntry(Text first, Text second) {
        this.first = first;
        this.second = second;
    }

    public void setPosition(Text firstPos, Text secondPos, Text keyPos) {
        this.firstPos = firstPos;
        this.secondPos = secondPos;
        this.keyPos = keyPos;
    }

    public void setTE(TripleEntry te) {
        this.first.set(te.first);
        this.second.set(te.second);
        this.firstPos.set(te.firstPos);
        this.secondPos.set(te.secondPos);
        this.keyPos.set(te.keyPos);
    }

    public Text getFirst() {
        return this.first;
    }

    public Text getSecond() {
        return this.second;
    }

    public Text getFirstPos() {
        return this.firstPos;
    }

    public Text getSecondPos() {
        return this.secondPos;
    }

    public Text getKeyPos() {
        return this.keyPos;
    }

    public void write(DataOutput out) throws IOException {
        this.first.write(out);
        this.second.write(out);
        this.firstPos.write(out);
        this.secondPos.write(out);
        this.keyPos.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.first.readFields(in);
        this.second.readFields(in);
        this.firstPos.readFields(in);
        this.secondPos.readFields(in);
        this.keyPos.readFields(in);
    }

    public int hashCode() {
        int result = 7;
        result = result * 17 + this.first.hashCode();
        result = result * 17 + this.second.hashCode();
        result = result * 17 + this.firstPos.hashCode();
        result = result * 17 + this.secondPos.hashCode();
        result = result * 17 + this.keyPos.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TripleEntry) {
            TripleEntry trip = (TripleEntry)o;
            return this.first.equals((Object)trip.first) && this.second.equals((Object)trip.second) && this.firstPos.equals((Object)trip.firstPos) && this.secondPos.equals((Object)trip.secondPos) && this.keyPos.equals((Object)trip.keyPos);
        }
        return false;
    }

    public String toString() {
        return this.first + "\t" + this.firstPos + "\t" + this.second + "\t" + this.secondPos + "\t" + this.keyPos;
    }

    public int compareTo(TripleEntry o) {
        int cmp = this.first.compareTo((BinaryComparable)o.first);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.firstPos.compareTo((BinaryComparable)o.firstPos);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.second.compareTo((BinaryComparable)o.second);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.secondPos.compareTo((BinaryComparable)o.secondPos);
        if (cmp != 0) {
            return cmp;
        }
        return this.keyPos.compareTo((BinaryComparable)o.keyPos);
    }
}

