/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.rya.joinselect.mr.utils.CardinalityType;
import org.apache.rya.joinselect.mr.utils.TripleEntry;

public class TripleCard
implements WritableComparable<TripleCard> {
    private CardinalityType card = null;
    private TripleEntry te = null;
    private CardinalityType tempCard = new CardinalityType();
    private TripleEntry tempTe = new TripleEntry();

    public TripleCard() {
    }

    public TripleCard(CardinalityType card) {
        this.setCard(card);
    }

    public TripleCard(TripleEntry te) {
        this.setTE(te);
    }

    public void setCard(CardinalityType card) {
        this.tempCard.set(card);
        this.card = this.tempCard;
        this.te = null;
    }

    public void setTE(TripleEntry te) {
        this.tempTe.setTE(te);
        this.te = this.tempTe;
        this.card = null;
    }

    public CardinalityType getCard() {
        return this.card;
    }

    public TripleEntry getTE() {
        return this.te;
    }

    public boolean isCardNull() {
        return this.card == null;
    }

    public boolean isTeNull() {
        return this.te == null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.card != null) {
            out.writeBoolean(true);
            this.card.write(out);
        } else {
            out.writeBoolean(false);
            this.te.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.tempCard.readFields(in);
            this.card = this.tempCard;
            this.te = null;
        } else {
            this.tempTe.readFields(in);
            this.te = this.tempTe;
            this.card = null;
        }
    }

    public int hashCode() {
        int result = 7;
        result = this.card != null ? result * 17 + this.card.hashCode() : result * 17 + this.te.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TripleCard) {
            TripleCard comp = (TripleCard)o;
            if (this.card != null) {
                return this.card.equals(comp.card);
            }
            return this.te.equals(comp.te);
        }
        return false;
    }

    public String toString() {
        if (this.card != null) {
            return this.card.toString();
        }
        return this.te.toString();
    }

    public int compareTo(TripleCard o) {
        if (this.card != null) {
            return this.card.compareTo(o.card);
        }
        return this.te.compareTo(o.te);
    }
}

