/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr.utils;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.rya.accumulo.AccumuloRdfConstants;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.joinselect.mr.utils.CardList;
import org.apache.rya.joinselect.mr.utils.CompositeType;
import org.apache.rya.joinselect.mr.utils.TripleCard;
import org.apache.rya.joinselect.mr.utils.TripleEntry;

public class JoinSelectStatsUtil {
    public static void initSumMRJob(Job job, String inputPath, String outtable, String auths) throws AccumuloSecurityException, IOException {
        Configuration conf = job.getConfiguration();
        String username = conf.get("username");
        String password = conf.get("password");
        String instance = conf.get("instance");
        String zookeepers = conf.get("zookeepers");
        if (zookeepers == null) {
            throw new IllegalArgumentException("Must specify zookeepers");
        }
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken((CharSequence)password));
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
        SequenceFileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapOutputKeyClass(TripleEntry.class);
        job.setMapOutputValueClass(CardList.class);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)outtable);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
    }

    public static void initTableMRJob(Job job, String intable, String outtable, String auths) throws AccumuloSecurityException {
        Configuration conf = job.getConfiguration();
        String username = conf.get("username");
        String password = conf.get("password");
        String instance = conf.get("instance");
        String zookeepers = conf.get("zookeepers");
        System.out.println("Zookeepers are " + auths);
        if (zookeepers == null) {
            throw new IllegalArgumentException("Must specify either mock or zookeepers");
        }
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken((CharSequence)password));
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)new Authorizations(new String[]{auths}));
        AccumuloInputFormat.setInputTableName((Job)job, (String)intable);
        job.setInputFormatClass(AccumuloInputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken((CharSequence)password));
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)outtable);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
    }

    public static void initTabToSeqFileJob(Job job, String intable, String outpath, String auths) throws AccumuloSecurityException {
        Configuration conf = job.getConfiguration();
        String username = conf.get("username");
        String password = conf.get("password");
        String instance = conf.get("instance");
        String zookeepers = conf.get("zookeepers");
        System.out.println("Zookeepers are " + auths);
        if (zookeepers == null) {
            throw new IllegalArgumentException("Must specify either mock or zookeepers");
        }
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)instance, (String)zookeepers);
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken((CharSequence)password));
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)new Authorizations(new String[]{auths}));
        AccumuloInputFormat.setInputTableName((Job)job, (String)intable);
        job.setInputFormatClass(AccumuloInputFormat.class);
        job.setMapOutputKeyClass(CompositeType.class);
        job.setMapOutputValueClass(TripleCard.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(outpath));
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(CompositeType.class);
        job.setOutputValueClass(TripleCard.class);
    }

    public static void initJoinMRJob(Job job, String prospectsPath, String spoPath, Class<? extends Mapper<CompositeType, TripleCard, ?, ?>> mapperClass, String outPath, String auths) throws AccumuloSecurityException {
        MultipleInputs.addInputPath((Job)job, (Path)new Path(prospectsPath), SequenceFileInputFormat.class, mapperClass);
        MultipleInputs.addInputPath((Job)job, (Path)new Path(spoPath), SequenceFileInputFormat.class, mapperClass);
        job.setMapOutputKeyClass(CompositeType.class);
        job.setMapOutputValueClass(TripleCard.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(outPath));
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(TripleEntry.class);
        job.setOutputValueClass(CardList.class);
    }

    public static Mutation createMutation(TripleRow tripleRow) {
        Text cfText;
        Mutation mutation = new Mutation(new Text(tripleRow.getRow()));
        byte[] columnVisibility = tripleRow.getColumnVisibility();
        ColumnVisibility cv = columnVisibility == null ? AccumuloRdfConstants.EMPTY_CV : new ColumnVisibility(columnVisibility);
        Long timestamp = tripleRow.getTimestamp();
        boolean hasts = timestamp != null;
        timestamp = timestamp == null ? 0L : timestamp;
        byte[] value = tripleRow.getValue();
        Value v = value == null ? AccumuloRdfConstants.EMPTY_VALUE : new Value(value);
        byte[] columnQualifier = tripleRow.getColumnQualifier();
        Text cqText = columnQualifier == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnQualifier);
        byte[] columnFamily = tripleRow.getColumnFamily();
        Text text = cfText = columnFamily == null ? RdfCloudTripleStoreConstants.EMPTY_TEXT : new Text(columnFamily);
        if (hasts) {
            mutation.put(cfText, cqText, cv, timestamp.longValue(), v);
        } else {
            mutation.put(cfText, cqText, cv, v);
        }
        return mutation;
    }
}

