/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class CompositeType
implements WritableComparable<CompositeType> {
    private Text oldKey;
    private IntWritable priority;

    public CompositeType() {
        this.oldKey = new Text();
        this.priority = new IntWritable();
    }

    public CompositeType(String oldKey, int priority) {
        this.oldKey = new Text(oldKey);
        this.priority = new IntWritable(priority);
    }

    public CompositeType(Text oldKey, IntWritable priority) {
        this.oldKey = oldKey;
        this.priority = priority;
    }

    public void setOldKey(Text oldKey) {
        this.oldKey = oldKey;
    }

    public void setPriority(IntWritable priority) {
        this.priority = priority;
    }

    public Text getOldKey() {
        return this.oldKey;
    }

    public IntWritable getPriority() {
        return this.priority;
    }

    public void write(DataOutput out) throws IOException {
        this.oldKey.write(out);
        this.priority.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.oldKey.readFields(in);
        this.priority.readFields(in);
    }

    public int hashCode() {
        int result = 7;
        result = result * 17 + this.oldKey.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof CompositeType) {
            CompositeType comp = (CompositeType)o;
            return this.oldKey.equals((Object)comp.oldKey) && this.priority.equals((Object)comp.priority);
        }
        return false;
    }

    public String toString() {
        return this.oldKey + "\t" + this.priority;
    }

    public int compareTo(CompositeType o) {
        int compare = this.getOldKey().compareTo((BinaryComparable)o.getOldKey());
        if (compare != 0) {
            return compare;
        }
        return this.getPriority().compareTo(o.getPriority());
    }
}

