/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class CardinalityType
implements WritableComparable<CardinalityType> {
    private LongWritable card;
    private Text cardType;
    private LongWritable ts;

    public CardinalityType() {
        this.card = new LongWritable();
        this.cardType = new Text();
        this.ts = new LongWritable();
    }

    public CardinalityType(int card, String cardType, long ts) {
        this.card = new LongWritable((long)card);
        this.cardType = new Text(cardType);
        this.ts = new LongWritable(ts);
    }

    public CardinalityType(LongWritable card, Text cardType, LongWritable ts) {
        this.card = card;
        this.ts = ts;
        this.cardType = cardType;
    }

    public void set(CardinalityType ct) {
        this.card.set(ct.card.get());
        this.ts.set(ct.ts.get());
        this.cardType.set(ct.cardType);
    }

    public void setCard(LongWritable card) {
        this.card = card;
    }

    public void setCardType(Text cardType) {
        this.cardType = cardType;
    }

    public void setTS(LongWritable ts) {
        this.ts = ts;
    }

    public LongWritable getCard() {
        return this.card;
    }

    public Text getCardType() {
        return this.cardType;
    }

    public LongWritable getTS() {
        return this.ts;
    }

    public void write(DataOutput out) throws IOException {
        this.card.write(out);
        this.cardType.write(out);
        this.ts.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.card.readFields(in);
        this.cardType.readFields(in);
        this.ts.readFields(in);
    }

    public int hashCode() {
        int result = 7;
        result = result * 17 + this.card.hashCode();
        result = result * 17 + this.cardType.hashCode();
        result = result * 17 + this.ts.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof CardinalityType) {
            CardinalityType trip = (CardinalityType)o;
            return this.card.equals((Object)trip.card) && this.cardType.equals((Object)trip.cardType) && this.ts.equals((Object)trip.ts);
        }
        return false;
    }

    public String toString() {
        return this.card + "   " + this.cardType + "   " + this.ts;
    }

    public int compareTo(CardinalityType o) {
        int cmp = this.cardType.compareTo((BinaryComparable)o.cardType);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.ts.compareTo(o.ts);
        if (cmp != 0) {
            return cmp;
        }
        return this.card.compareTo(o.card);
    }
}

