/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.rya.joinselect.mr.utils.CardList;
import org.apache.rya.joinselect.mr.utils.JoinSelectStatsUtil;
import org.apache.rya.joinselect.mr.utils.TripleEntry;

public class JoinSelectStatisticsSum
extends Configured
implements Tool {
    public int run(String[] args) throws AccumuloSecurityException, IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = this.getConf();
        String outTable = conf.get("selectivity.table");
        String auths = conf.get("auths");
        String inPath = conf.get("inputpath");
        assert (outTable != null && inPath != null);
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        JoinSelectStatsUtil.initSumMRJob(job, inPath, outTable, auths);
        job.setMapperClass(CardinalityIdentityMapper.class);
        job.setCombinerClass(CardinalityIdentityCombiner.class);
        job.setReducerClass(CardinalityIdentityReducer.class);
        job.setNumReduceTasks(32);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class CardinalityIdentityCombiner
    extends Reducer<TripleEntry, CardList, TripleEntry, CardList> {
        public void reduce(TripleEntry key, Iterable<CardList> values, Reducer.Context context) throws IOException, InterruptedException {
            CardList cl = new CardList();
            LongWritable s = new LongWritable(0L);
            LongWritable p = new LongWritable(0L);
            LongWritable o = new LongWritable(0L);
            LongWritable sp = new LongWritable(0L);
            LongWritable po = new LongWritable(0L);
            LongWritable so = new LongWritable(0L);
            for (CardList val : values) {
                s.set(s.get() + val.getcardS().get());
                p.set(p.get() + val.getcardP().get());
                o.set(o.get() + val.getcardO().get());
                sp.set(sp.get() + val.getcardSP().get());
                po.set(po.get() + val.getcardPO().get());
                so.set(so.get() + val.getcardSO().get());
            }
            cl.setCard(s, p, o, sp, po, so);
            context.write((Object)key, (Object)cl);
        }
    }

    public static class CardinalityIdentityReducer
    extends Reducer<TripleEntry, CardList, Text, Mutation> {
        private static final String DELIM = "\u0000";

        public void reduce(TripleEntry te, Iterable<CardList> values, Reducer.Context context) throws IOException, InterruptedException {
            Mutation m3;
            Mutation m2;
            Mutation m1;
            CardList cl = new CardList();
            LongWritable s = new LongWritable(0L);
            LongWritable p = new LongWritable(0L);
            LongWritable o = new LongWritable(0L);
            LongWritable sp = new LongWritable(0L);
            LongWritable po = new LongWritable(0L);
            LongWritable so = new LongWritable(0L);
            for (CardList val : values) {
                s.set(s.get() + val.getcardS().get());
                p.set(p.get() + val.getcardP().get());
                o.set(o.get() + val.getcardO().get());
                sp.set(sp.get() + val.getcardSP().get());
                po.set(po.get() + val.getcardPO().get());
                so.set(so.get() + val.getcardSO().get());
            }
            cl.setCard(s, p, o, sp, po, so);
            Text row = te.getSecond().toString().length() > 0 ? new Text(te.getFirstPos().toString() + te.getSecondPos().toString() + DELIM + te.getFirst().toString() + DELIM + te.getSecond()) : new Text(te.getFirstPos().toString() + DELIM + te.getFirst().toString());
            if (te.getKeyPos().toString().equals("subject") || te.getKeyPos().toString().equals("predicate") || te.getKeyPos().toString().equals("object")) {
                m1 = new Mutation(row);
                m1.put(new Text(te.getKeyPos().toString() + "subject"), new Text(cl.getcardS().toString()), new Value(new byte[0]));
                m2 = new Mutation(row);
                m2.put(new Text(te.getKeyPos().toString() + "predicate"), new Text(cl.getcardP().toString()), new Value(new byte[0]));
                m3 = new Mutation(row);
                m3.put(new Text(te.getKeyPos().toString() + "object"), new Text(cl.getcardO().toString()), new Value(new byte[0]));
            } else if (te.getKeyPos().toString().equals("predicatesubject") || te.getKeyPos().toString().equals("objectpredicate") || te.getKeyPos().toString().equals("subjectobject")) {
                String jOrder = this.reverseJoinOrder(te.getKeyPos().toString());
                m1 = new Mutation(row);
                m1.put(new Text(jOrder + "predicatesubject"), new Text(cl.getcardSP().toString()), new Value(new byte[0]));
                m2 = new Mutation(row);
                m2.put(new Text(jOrder + "objectpredicate"), new Text(cl.getcardPO().toString()), new Value(new byte[0]));
                m3 = new Mutation(row);
                m3.put(new Text(jOrder + "subjectobject"), new Text(cl.getcardSO().toString()), new Value(new byte[0]));
            } else {
                m1 = new Mutation(row);
                m1.put(new Text(te.getKeyPos().toString() + "subjectpredicate"), new Text(cl.getcardSP().toString()), new Value(new byte[0]));
                m2 = new Mutation(row);
                m2.put(new Text(te.getKeyPos().toString() + "predicateobject"), new Text(cl.getcardPO().toString()), new Value(new byte[0]));
                m3 = new Mutation(row);
                m3.put(new Text(te.getKeyPos().toString() + "objectsubject"), new Text(cl.getcardSO().toString()), new Value(new byte[0]));
            }
            context.write((Object)new Text(""), (Object)m1);
            context.write((Object)new Text(""), (Object)m2);
            context.write((Object)new Text(""), (Object)m3);
        }

        private String reverseJoinOrder(String s) {
            if (s.equals("predicatesubject")) {
                return "subjectpredicate";
            }
            if (s.equals("objectpredicate")) {
                return "predicateobject";
            }
            if (s.equals("subjectobject")) {
                return "objectsubject";
            }
            throw new IllegalArgumentException("Invalid join type.");
        }
    }

    public static class CardinalityIdentityMapper
    extends Mapper<TripleEntry, CardList, TripleEntry, CardList> {
        public void map(TripleEntry key, CardList value, Mapper.Context context) throws IOException, InterruptedException {
            if (key.getSecond().toString().length() != 0 && key.getSecondPos().toString().length() != 0) {
                TripleEntry te1 = new TripleEntry(key.getFirst(), new Text(""), key.getFirstPos(), new Text(""), key.getKeyPos());
                TripleEntry te2 = new TripleEntry(key.getSecond(), new Text(""), key.getSecondPos(), new Text(""), key.getKeyPos());
                context.write((Object)te1, (Object)value);
                context.write((Object)te2, (Object)value);
                context.write((Object)key, (Object)value);
            } else if (key.getSecond().toString().length() == 0 && key.getSecondPos().toString().length() == 0) {
                context.write((Object)key, (Object)value);
            }
        }
    }
}

