/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaTripleContext;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;
import org.apache.rya.joinselect.mr.utils.CompositeType;
import org.apache.rya.joinselect.mr.utils.JoinSelectStatsUtil;
import org.apache.rya.joinselect.mr.utils.TripleCard;
import org.apache.rya.joinselect.mr.utils.TripleEntry;

public class JoinSelectSpoTableOutput
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String inTable = conf.get("spo.table");
        String auths = conf.get("auths");
        String outPath = conf.get("spo.outputpath");
        assert (inTable != null && outPath != null);
        Job job = new Job(conf, ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        conf.setBoolean("mapreduce.job.user.classpath.first", true);
        JoinSelectStatsUtil.initTabToSeqFileJob(job, inTable, outPath, auths);
        job.setMapperClass(JoinSelectMapper.class);
        job.setNumReduceTasks(0);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class JoinSelectMapper
    extends Mapper<Key, Value, CompositeType, TripleCard> {
        private RyaTripleContext ryaContext;
        private static final String DELIM = "\u0000";

        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.ryaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)new AccumuloRdfConfiguration(context.getConfiguration()));
                RyaStatement ryaStatement = this.ryaContext.deserializeTriple(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO, new TripleRow(row.getRow().getBytes(), row.getColumnFamily().getBytes(), row.getColumnQualifier().getBytes(), Long.valueOf(row.getTimestamp()), row.getColumnVisibility().getBytes(), data.get()));
                Text s = new Text(ryaStatement.getSubject().getData());
                Text p = new Text(ryaStatement.getPredicate().getData());
                Text o = new Text(ryaStatement.getObject().getData());
                Text sp = new Text(ryaStatement.getSubject().getData() + DELIM + ryaStatement.getPredicate().getData());
                Text po = new Text(ryaStatement.getPredicate().getData() + DELIM + ryaStatement.getObject().getData());
                Text so = new Text(ryaStatement.getSubject().getData() + DELIM + ryaStatement.getObject().getData());
                Text ps = new Text(ryaStatement.getPredicate().getData() + DELIM + ryaStatement.getSubject().getData());
                Text op = new Text(ryaStatement.getObject().getData() + DELIM + ryaStatement.getPredicate().getData());
                Text os = new Text(ryaStatement.getObject().getData() + DELIM + ryaStatement.getSubject().getData());
                TripleEntry t1 = new TripleEntry(s, p, new Text("subject"), new Text("predicate"), new Text("object"));
                TripleEntry t2 = new TripleEntry(p, o, new Text("predicate"), new Text("object"), new Text("subject"));
                TripleEntry t3 = new TripleEntry(o, s, new Text("object"), new Text("subject"), new Text("predicate"));
                TripleEntry t4 = new TripleEntry(s, new Text(""), new Text("subject"), new Text(""), new Text("predicateobject"));
                TripleEntry t5 = new TripleEntry(p, new Text(""), new Text("predicate"), new Text(""), new Text("objectsubject"));
                TripleEntry t6 = new TripleEntry(o, new Text(""), new Text("object"), new Text(""), new Text("subjectpredicate"));
                TripleEntry t7 = new TripleEntry(s, new Text(""), new Text("subject"), new Text(""), new Text("objectpredicate"));
                TripleEntry t8 = new TripleEntry(p, new Text(""), new Text("predicate"), new Text(""), new Text("subjectobject"));
                TripleEntry t9 = new TripleEntry(o, new Text(""), new Text("object"), new Text(""), new Text("predicatesubject"));
                context.write((Object)new CompositeType(o, new IntWritable(2)), (Object)new TripleCard(t1));
                context.write((Object)new CompositeType(s, new IntWritable(2)), (Object)new TripleCard(t2));
                context.write((Object)new CompositeType(p, new IntWritable(2)), (Object)new TripleCard(t3));
                context.write((Object)new CompositeType(po, new IntWritable(2)), (Object)new TripleCard(t4));
                context.write((Object)new CompositeType(so, new IntWritable(2)), (Object)new TripleCard(t5));
                context.write((Object)new CompositeType(sp, new IntWritable(2)), (Object)new TripleCard(t6));
                context.write((Object)new CompositeType(op, new IntWritable(2)), (Object)new TripleCard(t7));
                context.write((Object)new CompositeType(os, new IntWritable(2)), (Object)new TripleCard(t8));
                context.write((Object)new CompositeType(ps, new IntWritable(2)), (Object)new TripleCard(t9));
            }
            catch (TripleRowResolverException e) {
                e.printStackTrace();
            }
        }
    }
}

