/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.rya.joinselect.mr.utils.CardinalityType;
import org.apache.rya.joinselect.mr.utils.CompositeType;
import org.apache.rya.joinselect.mr.utils.JoinSelectStatsUtil;
import org.apache.rya.joinselect.mr.utils.TripleCard;

public class JoinSelectProspectOutput
extends Configured
implements Tool {
    public int run(String[] args) throws AccumuloSecurityException, IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = this.getConf();
        String inTable = conf.get("prospects.table");
        String auths = conf.get("auths");
        String outPath = conf.get("prospects.outputpath");
        assert (inTable != null && outPath != null);
        Job job = new Job(conf, ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        conf.setBoolean("mapreduce.job.user.classpath.first", true);
        JoinSelectStatsUtil.initTabToSeqFileJob(job, inTable, outPath, auths);
        job.setMapperClass(CardinalityMapper.class);
        job.setNumReduceTasks(0);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class CardinalityMapper
    extends Mapper<Key, Value, CompositeType, TripleCard> {
        private static final String DELIM = "\u0000";
        Text inText = new Text();
        Pattern splitPattern = Pattern.compile("\u0000");

        public void map(Key key, Value data, Mapper.Context context) throws IOException, InterruptedException {
            key.getRow(this.inText);
            String[] cardData = this.splitPattern.split(this.inText.toString().trim(), 4);
            if (cardData.length == 3 && (cardData[0].equals("subject") || cardData[0].equals("object") || cardData[0].equals("predicate"))) {
                Text tripleValType = new Text(cardData[0]);
                Text cardKey = new Text(cardData[1]);
                LongWritable ts = new LongWritable(Long.valueOf(cardData[2]).longValue());
                String s = new String(data.get(), StandardCharsets.UTF_8);
                LongWritable card = new LongWritable(Long.parseLong(s));
                CompositeType cType = new CompositeType(cardKey, new IntWritable(1));
                TripleCard tCard = new TripleCard(new CardinalityType(card, tripleValType, ts));
                context.write((Object)new CompositeType(cardKey, new IntWritable(1)), (Object)new TripleCard(new CardinalityType(card, tripleValType, ts)));
            } else if (cardData.length == 4 && (cardData[0].equals("subjectpredicate") || cardData[0].equals("subjectobject") || cardData[0].equals("predicateobject"))) {
                Text tripleValType = new Text(cardData[0]);
                Text cardKey = new Text(cardData[1] + DELIM + cardData[2]);
                LongWritable ts = new LongWritable(Long.valueOf(cardData[3]).longValue());
                String s = new String(data.get(), StandardCharsets.UTF_8);
                LongWritable card = new LongWritable(Long.parseLong(s));
                CompositeType cType = new CompositeType(cardKey, new IntWritable(1));
                TripleCard tCard = new TripleCard(new CardinalityType(card, tripleValType, ts));
                context.write((Object)new CompositeType(cardKey, new IntWritable(1)), (Object)new TripleCard(new CardinalityType(card, tripleValType, ts)));
            }
        }
    }
}

