/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.rya.joinselect.mr.utils.CardList;
import org.apache.rya.joinselect.mr.utils.CardinalityType;
import org.apache.rya.joinselect.mr.utils.CompositeType;
import org.apache.rya.joinselect.mr.utils.JoinSelectStatsUtil;
import org.apache.rya.joinselect.mr.utils.TripleCard;
import org.apache.rya.joinselect.mr.utils.TripleEntry;

public class JoinSelectAggregate
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String inPath1 = conf.get("prospects.outputpath");
        String inPath2 = conf.get("spo.outputpath");
        String auths = conf.get("auths");
        String outPath = conf.get("outputpath");
        assert (inPath1 != null && inPath2 != null && outPath != null);
        Job job = new Job(conf, ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        conf.setBoolean("mapreduce.job.user.classpath.first", true);
        JoinSelectStatsUtil.initJoinMRJob(job, inPath1, inPath2, JoinSelectAggregateMapper.class, outPath, auths);
        job.setSortComparatorClass(JoinSelectSortComparator.class);
        job.setGroupingComparatorClass(JoinSelectGroupComparator.class);
        job.setPartitionerClass(JoinSelectPartitioner.class);
        job.setReducerClass(JoinReducer.class);
        job.setNumReduceTasks(32);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class JoinSelectSortComparator
    extends WritableComparator {
        protected JoinSelectSortComparator() {
            super(CompositeType.class, true);
        }

        public int compare(WritableComparable w1, WritableComparable w2) {
            CompositeType ct1 = (CompositeType)w1;
            CompositeType ct2 = (CompositeType)w2;
            return ct1.compareTo(ct2);
        }
    }

    public static class JoinSelectGroupComparator
    extends WritableComparator {
        protected JoinSelectGroupComparator() {
            super(CompositeType.class, true);
        }

        public int compare(WritableComparable w1, WritableComparable w2) {
            CompositeType ct1 = (CompositeType)w1;
            CompositeType ct2 = (CompositeType)w2;
            return ct1.getOldKey().compareTo((BinaryComparable)ct2.getOldKey());
        }
    }

    public static class JoinSelectPartitioner
    extends Partitioner<CompositeType, TripleCard> {
        public int getPartition(CompositeType key, TripleCard value, int numPartitions) {
            return Math.abs(key.getOldKey().hashCode() * 127) % numPartitions;
        }
    }

    public static class JoinReducer
    extends Reducer<CompositeType, TripleCard, TripleEntry, CardList> {
        public void reduce(CompositeType key, Iterable<TripleCard> values, Reducer.Context context) throws IOException, InterruptedException {
            CardinalityType subjectCard = null;
            CardinalityType objectCard = null;
            CardinalityType predicateCard = null;
            CardinalityType spCard = null;
            CardinalityType soCard = null;
            CardinalityType poCard = null;
            CardList cList = new CardList(0L, 0L, 0L, 0L, 0L, 0L);
            boolean listEmpty = true;
            for (TripleCard val : values) {
                if (!val.isCardNull()) {
                    CardinalityType card = val.getCard();
                    if (card.getCardType().toString().equals("object")) {
                        if (objectCard == null) {
                            objectCard = new CardinalityType();
                            objectCard.set(card);
                            continue;
                        }
                        if (objectCard.compareTo(card) <= 0) continue;
                        objectCard.set(card);
                        continue;
                    }
                    if (card.getCardType().toString().equals("predicate")) {
                        if (predicateCard == null) {
                            predicateCard = new CardinalityType();
                            predicateCard.set(card);
                            continue;
                        }
                        if (predicateCard.compareTo(card) <= 0) continue;
                        predicateCard.set(card);
                        continue;
                    }
                    if (card.getCardType().toString().equals("subject")) {
                        if (subjectCard == null) {
                            subjectCard = new CardinalityType();
                            subjectCard.set(card);
                            continue;
                        }
                        if (subjectCard.compareTo(card) <= 0) continue;
                        subjectCard.set(card);
                        continue;
                    }
                    if (card.getCardType().toString().equals("subjectpredicate")) {
                        if (spCard == null) {
                            spCard = new CardinalityType();
                            spCard.set(card);
                            continue;
                        }
                        if (spCard.compareTo(card) <= 0) continue;
                        spCard.set(card);
                        continue;
                    }
                    if (card.getCardType().toString().equals("subjectobject")) {
                        if (soCard == null) {
                            soCard = new CardinalityType();
                            soCard.set(card);
                            continue;
                        }
                        if (soCard.compareTo(card) <= 0) continue;
                        soCard.set(card);
                        continue;
                    }
                    if (!card.getCardType().toString().equals("predicateobject")) continue;
                    if (poCard == null) {
                        poCard = new CardinalityType();
                        poCard.set(card);
                        continue;
                    }
                    if (poCard.compareTo(card) <= 0) continue;
                    poCard.set(card);
                    continue;
                }
                if (listEmpty) {
                    if (subjectCard != null || predicateCard != null || objectCard != null) {
                        if (subjectCard != null) {
                            cList.setSCard(subjectCard.getCard().get());
                        }
                        if (predicateCard != null) {
                            cList.setPCard(predicateCard.getCard().get());
                        }
                        if (objectCard != null) {
                            cList.setOCard(objectCard.getCard().get());
                        }
                        listEmpty = false;
                    } else if (spCard != null || poCard != null || soCard != null) {
                        if (spCard != null) {
                            cList.setSPCard(spCard.getCard().get());
                        }
                        if (poCard != null) {
                            cList.setPOCard(poCard.getCard().get());
                        }
                        if (soCard != null) {
                            cList.setSOCard(soCard.getCard().get());
                        }
                        listEmpty = false;
                    }
                }
                if (val.isTeNull() || listEmpty) continue;
                TripleEntry triple = val.getTE();
                context.write((Object)triple, (Object)cList);
            }
        }
    }

    public static class JoinSelectAggregateMapper
    extends Mapper<CompositeType, TripleCard, CompositeType, TripleCard> {
        public void map(CompositeType key, TripleCard value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)value);
        }
    }
}

