/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect.mr;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.rya.joinselect.mr.utils.JoinSelectStatsUtil;

public class FullTableSize
extends Configured
implements Tool {
    private static final String DELIM = "\u0000";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new FullTableSize(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String inTable = conf.get("spo.table");
        String outTable = conf.get("selectivity.table");
        String auths = conf.get("auths");
        assert (inTable != null && outTable != null);
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        JoinSelectStatsUtil.initTableMRJob(job, inTable, outTable, auths);
        job.setMapperClass(FullTableMapper.class);
        job.setCombinerClass(FullTableCombiner.class);
        job.setReducerClass(FullTableReducer.class);
        job.setNumReduceTasks(1);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class FullTableCombiner
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (IntWritable i : values) {
                count += i.get();
            }
            context.write((Object)key, (Object)new IntWritable(count));
        }
    }

    public static class FullTableReducer
    extends Reducer<Text, IntWritable, Text, Mutation> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (IntWritable i : values) {
                count += i.get();
            }
            String countStr = Integer.toString(count);
            Mutation m = new Mutation(new Text("subjectpredicateobject\u0000FullTableCardinality"));
            m.put(new Text("FullTableCardinality"), new Text(countStr), new Value(new byte[0]));
            context.write((Object)new Text(""), (Object)m);
        }
    }

    public static class FullTableMapper
    extends Mapper<Key, Value, Text, IntWritable> {
        private static final IntWritable ONE = new IntWritable(1);

        public void map(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new Text("COUNT"), (Object)ONE);
        }
    }
}

