/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;

public class CardinalityCalcUtil {
    private static final String DELIM = "\u0000";

    private static String intToTriplePlace(int i) {
        int place = i;
        switch (place) {
            case 0: {
                return "subject";
            }
            case 1: {
                return "predicate";
            }
            case 2: {
                return "object";
            }
        }
        throw new IllegalArgumentException("Invalid integer triple place.");
    }

    private static int triplePlaceToInt(String s) {
        if (s.equals("subject")) {
            return 0;
        }
        if (s.equals("predicate")) {
            return 1;
        }
        if (s.equals("object")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid triple place.");
    }

    private static List<String> getVariablePos(StatementPattern sp) {
        ArrayList<String> posList = new ArrayList<String>();
        List varList = sp.getVarList();
        for (int i = 0; i < 3; ++i) {
            if (((Var)varList.get(i)).isConstant()) continue;
            posList.add(CardinalityCalcUtil.intToTriplePlace(i));
        }
        return posList;
    }

    private static List<String> getConstantPos(StatementPattern sp) {
        ArrayList<String> posList = new ArrayList<String>();
        List varList = sp.getVarList();
        for (int i = 0; i < 3; ++i) {
            if (!((Var)varList.get(i)).isConstant()) continue;
            posList.add(CardinalityCalcUtil.intToTriplePlace(i));
        }
        return posList;
    }

    public static String getRow(StatementPattern sp, boolean joinTable) {
        String row = "";
        String values = "";
        List varList = sp.getVarList();
        List<String> constList = CardinalityCalcUtil.getConstantPos(sp);
        for (String s : constList) {
            int i = CardinalityCalcUtil.triplePlaceToInt(s);
            if (row.equals("subject") && s.equals("object") && joinTable) {
                row = s + row;
                if (values.length() == 0) {
                    values = values + CardinalityCalcUtil.removeQuotes(((Var)varList.get(i)).getValue().toString());
                    continue;
                }
                values = CardinalityCalcUtil.removeQuotes(((Var)varList.get(i)).getValue().toString()) + DELIM + values;
                continue;
            }
            row = row + s;
            if (values.length() == 0) {
                values = values + CardinalityCalcUtil.removeQuotes(((Var)varList.get(i)).getValue().toString());
                continue;
            }
            values = values + DELIM + CardinalityCalcUtil.removeQuotes(((Var)varList.get(i)).getValue().toString());
        }
        return row + DELIM + values;
    }

    private static String removeQuotes(String s) {
        String trim = s.trim();
        if (trim.substring(0, 1).equals("\"")) {
            trim = trim.substring(1, trim.length() - 1);
        }
        return trim;
    }

    public static long getJCard(Key key) {
        String s = key.getColumnQualifier().toString();
        return Long.parseLong(s);
    }

    private static List<String> getJoinType(StatementPattern sp1, StatementPattern sp2) {
        ArrayList<String> joinList = new ArrayList<String>();
        List spList1 = sp1.getVarList();
        List spList2 = sp2.getVarList();
        List<String> pos1 = CardinalityCalcUtil.getVariablePos(sp1);
        List<String> pos2 = CardinalityCalcUtil.getVariablePos(sp2);
        for (String s : pos1) {
            for (String t : pos2) {
                int i = CardinalityCalcUtil.triplePlaceToInt(s);
                int j = CardinalityCalcUtil.triplePlaceToInt(t);
                if (!((Var)spList1.get(i)).getName().equals(((Var)spList2.get(j)).getName())) continue;
                joinList.add(s);
                joinList.add(t);
            }
        }
        if (joinList.size() == 4) {
            return CardinalityCalcUtil.orderJoinType(joinList);
        }
        return joinList;
    }

    private static List<String> orderJoinType(List<String> jList) {
        ArrayList<String> tempList = new ArrayList<String>();
        if (jList.get(0).equals("subject") && jList.get(2).equals("object")) {
            tempList.add(jList.get(2));
            tempList.add(jList.get(0));
            tempList.add(jList.get(3));
            tempList.add(jList.get(1));
            return tempList;
        }
        tempList.add(jList.get(0));
        tempList.add(jList.get(2));
        tempList.add(jList.get(1));
        tempList.add(jList.get(3));
        return tempList;
    }

    private static List<String> reverseJoinType(List<String> jList) {
        ArrayList<String> tempList = new ArrayList<String>();
        if (jList.get(2).equals("subject") && jList.get(3).equals("object")) {
            tempList.add(jList.get(3));
            tempList.add(jList.get(2));
            tempList.add(jList.get(1));
            tempList.add(jList.get(0));
            return tempList;
        }
        if (jList.get(2).equals("predicate") && jList.get(3).equals("subject")) {
            tempList.add(jList.get(3));
            tempList.add(jList.get(2));
            tempList.add(jList.get(1));
            tempList.add(jList.get(0));
            return tempList;
        }
        if (jList.get(2).equals("object") && jList.get(3).equals("predicate")) {
            tempList.add(jList.get(3));
            tempList.add(jList.get(2));
            tempList.add(jList.get(1));
            tempList.add(jList.get(0));
            return tempList;
        }
        tempList.add(jList.get(2));
        tempList.add(jList.get(3));
        tempList.add(jList.get(0));
        tempList.add(jList.get(1));
        return tempList;
    }

    public static List<String> getJoins(StatementPattern sp1, StatementPattern sp2) {
        ArrayList<String> jList = new ArrayList<String>();
        List<String> list = CardinalityCalcUtil.getJoinType(sp1, sp2);
        if (list.size() == 0) {
            return list;
        }
        if (list.size() == 2) {
            jList.add(list.get(0) + list.get(1));
            jList.add(list.get(1) + list.get(0));
            return jList;
        }
        list = CardinalityCalcUtil.orderJoinType(list);
        jList.add(list.get(0) + list.get(1) + list.get(2) + list.get(3));
        jList.add(list.get(0) + list.get(1) + list.get(3) + list.get(2));
        list = CardinalityCalcUtil.reverseJoinType(list);
        jList.add(list.get(0) + list.get(1) + list.get(2) + list.get(3));
        jList.add(list.get(0) + list.get(1) + list.get(3) + list.get(2));
        return jList;
    }
}

