/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.joinselect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.apache.rya.accumulo.AccumuloRdfUtils;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.layout.TableLayoutStrategy;
import org.apache.rya.api.persist.RdfDAOException;
import org.apache.rya.api.persist.RdfEvalStatsDAO;
import org.apache.rya.api.persist.joinselect.SelectivityEvalDAO;
import org.apache.rya.joinselect.CardinalityCalcUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class AccumuloSelectivityEvalDAO
implements SelectivityEvalDAO<RdfCloudTripleStoreConfiguration> {
    private boolean initialized = false;
    private RdfCloudTripleStoreConfiguration conf;
    private Connector connector;
    private TableLayoutStrategy tableLayoutStrategy;
    private boolean filtered = false;
    private boolean denormalized = false;
    private int FullTableCardinality = 0;
    private static final String DELIM = "\u0000";
    private Map<String, Long> joinMap = new HashMap<String, Long>();
    private RdfEvalStatsDAO<RdfCloudTripleStoreConfiguration> resd;

    public void init() throws RdfDAOException {
        try {
            if (this.isInitialized()) {
                throw new IllegalStateException("Already initialized");
            }
            if (!this.resd.isInitialized()) {
                this.resd.init();
            }
            Preconditions.checkNotNull((Object)this.connector);
            this.tableLayoutStrategy = this.conf.getTableLayoutStrategy();
            TableOperations tos = this.connector.tableOperations();
            AccumuloRdfUtils.createTableIfNotExist((TableOperations)tos, (String)this.tableLayoutStrategy.getSelectivity());
            AccumuloRdfUtils.createTableIfNotExist((TableOperations)tos, (String)this.tableLayoutStrategy.getProspects());
            this.initialized = true;
        }
        catch (Exception e) {
            throw new RdfDAOException((Throwable)e);
        }
    }

    public AccumuloSelectivityEvalDAO() {
    }

    public AccumuloSelectivityEvalDAO(RdfCloudTripleStoreConfiguration conf, Connector connector) {
        this.conf = conf;
        this.connector = connector;
    }

    public AccumuloSelectivityEvalDAO(RdfCloudTripleStoreConfiguration conf) {
        this.conf = conf;
        ZooKeeperInstance inst = new ZooKeeperInstance(conf.get("sc.cloudbase.instancename"), conf.get("sc.cloudbase.zookeepers"));
        try {
            this.connector = inst.getConnector(conf.get("sc.cloudbase.username"), (CharSequence)conf.get("sc.cloudbase.password"));
        }
        catch (AccumuloException e) {
            e.printStackTrace();
        }
        catch (AccumuloSecurityException e) {
            e.printStackTrace();
        }
    }

    public void destroy() throws RdfDAOException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.initialized = false;
    }

    public boolean isInitialized() throws RdfDAOException {
        return this.initialized;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public RdfCloudTripleStoreConfiguration getConf() {
        return this.conf;
    }

    public void setConf(RdfCloudTripleStoreConfiguration conf) {
        this.conf = conf;
    }

    public RdfEvalStatsDAO<RdfCloudTripleStoreConfiguration> getRdfEvalDAO() {
        return this.resd;
    }

    public void setRdfEvalDAO(RdfEvalStatsDAO<RdfCloudTripleStoreConfiguration> resd) {
        this.resd = resd;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setDenormalized(boolean denormalize) {
        this.denormalized = denormalize;
    }

    private double getJoinSelect(RdfCloudTripleStoreConfiguration conf, StatementPattern sp1, StatementPattern sp2) throws TableNotFoundException {
        boolean found2;
        boolean found1;
        Scanner joinScanner;
        if (this.FullTableCardinality == 0) {
            this.getTableSize(conf);
        }
        Authorizations authorizations = this.getAuths(conf);
        String row1 = CardinalityCalcUtil.getRow(sp1, true);
        String row2 = CardinalityCalcUtil.getRow(sp2, true);
        List<String> joinType = CardinalityCalcUtil.getJoins(sp1, sp2);
        if (joinType.size() == 0) {
            return 1.0;
        }
        if (joinType.size() == 2) {
            Scanner joinScanner2;
            long card1 = 0L;
            long card2 = 0L;
            boolean contCard1 = false;
            boolean contCard2 = false;
            String cacheRow1 = row1 + DELIM + joinType.get(0);
            String cacheRow2 = row2 + DELIM + joinType.get(1);
            long count1 = this.getCardinality(conf, sp1);
            long count2 = this.getCardinality(conf, sp2);
            if (count1 == 0L || count2 == 0L) {
                return 0.0;
            }
            if (this.joinMap.containsKey(cacheRow1)) {
                card1 = this.joinMap.get(cacheRow1);
                contCard1 = true;
            }
            if (this.joinMap.containsKey(cacheRow2)) {
                card2 = this.joinMap.get(cacheRow2);
                contCard2 = true;
            }
            if (!contCard1) {
                joinScanner2 = this.connector.createScanner(this.tableLayoutStrategy.getSelectivity(), authorizations);
                joinScanner2.setRange(Range.prefix((CharSequence)row1));
                for (Map.Entry entry : joinScanner2) {
                    if (!((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(0))) continue;
                    card1 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                    this.joinMap.put(cacheRow1, card1);
                    break;
                }
            }
            if (!contCard2) {
                joinScanner2 = this.connector.createScanner(this.tableLayoutStrategy.getSelectivity(), authorizations);
                joinScanner2.setRange(Range.prefix((CharSequence)row2));
                for (Map.Entry entry : joinScanner2) {
                    if (!((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(1))) continue;
                    card2 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                    this.joinMap.put(cacheRow2, card2);
                    break;
                }
            }
            if (!this.filtered && !this.denormalized) {
                double temp1 = Math.min((double)card1 / ((double)count1 * (double)this.FullTableCardinality), (double)card2 / ((double)count2 * (double)this.FullTableCardinality));
                double temp2 = Math.max((double)count1 / (double)this.FullTableCardinality, (double)count2 / (double)this.FullTableCardinality);
                return Math.min(temp1, temp2);
            }
            if (this.denormalized) {
                return Math.min(card1, card2);
            }
            return Math.min((double)card1 * (double)count2 / ((double)count1 * (double)this.FullTableCardinality * (double)this.FullTableCardinality), (double)card2 * (double)count1 / ((double)count2 * (double)this.FullTableCardinality * (double)this.FullTableCardinality));
        }
        String cacheRow1 = row1 + DELIM + joinType.get(0);
        String cacheRow2 = row1 + DELIM + joinType.get(1);
        String cacheRow3 = row2 + DELIM + joinType.get(2);
        String cacheRow4 = row2 + DELIM + joinType.get(3);
        long card1 = 0L;
        long card2 = 0L;
        long card3 = 0L;
        long card4 = 0L;
        boolean contCard1 = false;
        boolean contCard2 = false;
        long count1 = this.getCardinality(conf, sp1);
        long count2 = this.getCardinality(conf, sp2);
        if (count1 == 0L || count2 == 0L) {
            return 0.0;
        }
        if (this.joinMap.containsKey(cacheRow1) && this.joinMap.containsKey(cacheRow2)) {
            card1 = this.joinMap.get(cacheRow1);
            card2 = this.joinMap.get(cacheRow2);
            contCard1 = true;
        }
        if (this.joinMap.containsKey(cacheRow3) && this.joinMap.containsKey(cacheRow4)) {
            card3 = this.joinMap.get(cacheRow3);
            card4 = this.joinMap.get(cacheRow4);
            contCard2 = true;
        }
        if (!contCard1) {
            joinScanner = this.connector.createScanner(this.tableLayoutStrategy.getSelectivity(), authorizations);
            joinScanner.setRange(Range.prefix((CharSequence)row1));
            found1 = false;
            found2 = false;
            for (Map.Entry entry : joinScanner) {
                if (((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(0))) {
                    card1 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                    this.joinMap.put(cacheRow1, card1);
                    found1 = true;
                    if (!found1 || !found2) continue;
                    card1 = Math.min(card1, card2);
                    break;
                }
                if (!((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(1))) continue;
                card2 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                this.joinMap.put(cacheRow2, card2);
                found2 = true;
                if (!found1 || !found2) continue;
                card1 = Math.min(card1, card2);
                break;
            }
        }
        if (!contCard2) {
            joinScanner = this.connector.createScanner(this.tableLayoutStrategy.getSelectivity(), authorizations);
            joinScanner.setRange(Range.prefix((CharSequence)row2));
            found1 = false;
            found2 = false;
            for (Map.Entry entry : joinScanner) {
                if (((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(2))) {
                    card3 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                    this.joinMap.put(cacheRow3, card3);
                    found1 = true;
                    if (!found1 || !found2) continue;
                    card3 = Math.min(card3, card4);
                    break;
                }
                if (!((Key)entry.getKey()).getColumnFamily().toString().equals(joinType.get(3))) continue;
                card4 = CardinalityCalcUtil.getJCard((Key)entry.getKey());
                this.joinMap.put(cacheRow4, card4);
                found2 = true;
                if (!found1 || !found2) continue;
                card3 = Math.min(card3, card4);
                break;
            }
        }
        if (!this.filtered && !this.denormalized) {
            return Math.min((double)card1 / ((double)count1 * (double)this.FullTableCardinality), (double)card3 / ((double)count2 * (double)this.FullTableCardinality));
        }
        if (this.denormalized) {
            return Math.min(card1, card3);
        }
        return Math.min((double)card1 * (double)count2 / ((double)count1 * (double)this.FullTableCardinality * (double)this.FullTableCardinality), (double)card3 * (double)count1 / ((double)count2 * (double)this.FullTableCardinality * (double)this.FullTableCardinality));
    }

    private double getSpJoinSelect(RdfCloudTripleStoreConfiguration conf, TupleExpr te, StatementPattern sp1) throws TableNotFoundException {
        if (te instanceof StatementPattern) {
            return this.getJoinSelect(conf, (StatementPattern)te, sp1);
        }
        SpExternalCollector spe = new SpExternalCollector();
        te.visit((QueryModelVisitor)spe);
        List<QueryModelNode> espList = spe.getSpExtTup();
        if (espList.size() == 0) {
            Set tupBn = te.getAssuredBindingNames();
            Set eBn = sp1.getAssuredBindingNames();
            Sets.SetView intersect = Sets.intersection((Set)tupBn, (Set)eBn);
            return Math.pow(1.0E-4, intersect.size());
        }
        double min = Double.MAX_VALUE;
        double select = Double.MAX_VALUE;
        for (QueryModelNode node : espList) {
            if (node instanceof StatementPattern) {
                select = this.getJoinSelect(conf, sp1, (StatementPattern)node);
            } else if (node instanceof ExternalSet) {
                select = this.getExtJoinSelect((TupleExpr)sp1, (ExternalSet)node);
            }
            if (!(min > select)) continue;
            min = select;
        }
        return min;
    }

    public double getJoinSelect(RdfCloudTripleStoreConfiguration conf, TupleExpr te1, TupleExpr te2) throws TableNotFoundException {
        SpExternalCollector spe = new SpExternalCollector();
        te2.visit((QueryModelVisitor)spe);
        List<QueryModelNode> espList = spe.getSpExtTup();
        double min = Double.MAX_VALUE;
        for (QueryModelNode node : espList) {
            double select = this.getSelectivity(conf, te1, node);
            if (!(min > select)) continue;
            min = select;
        }
        return min;
    }

    private double getSelectivity(RdfCloudTripleStoreConfiguration conf, TupleExpr te, QueryModelNode node) throws TableNotFoundException {
        if (node instanceof StatementPattern) {
            return this.getSpJoinSelect(conf, te, (StatementPattern)node);
        }
        if (node instanceof ExternalSet) {
            return this.getExtJoinSelect(te, (ExternalSet)node);
        }
        return 0.0;
    }

    private double getExtJoinSelect(TupleExpr te, ExternalSet eSet) {
        Set tupBn = te.getAssuredBindingNames();
        Set eBn = eSet.getAssuredBindingNames();
        Sets.SetView intersect = Sets.intersection((Set)tupBn, (Set)eBn);
        return Math.pow(1.0E-4, intersect.size());
    }

    public long getCardinality(RdfCloudTripleStoreConfiguration conf, StatementPattern sp) throws TableNotFoundException {
        Var subjectVar = sp.getSubjectVar();
        Resource subj = (Resource)this.getConstantValue(subjectVar);
        Var predicateVar = sp.getPredicateVar();
        IRI pred = (IRI)this.getConstantValue(predicateVar);
        Var objectVar = sp.getObjectVar();
        Value obj = this.getConstantValue(objectVar);
        Resource context = (Resource)this.getConstantValue(sp.getContextVar());
        double cardinality = 0.0;
        try {
            cardinality = 2 * this.getTableSize(conf);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            if (subj != null) {
                ArrayList<Value> values = new ArrayList<Value>();
                RdfEvalStatsDAO.CARDINALITY_OF card = RdfEvalStatsDAO.CARDINALITY_OF.SUBJECT;
                values.add((Value)subj);
                if (pred != null) {
                    values.add((Value)pred);
                    card = RdfEvalStatsDAO.CARDINALITY_OF.SUBJECTPREDICATE;
                } else if (obj != null) {
                    values.add(obj);
                    card = RdfEvalStatsDAO.CARDINALITY_OF.SUBJECTOBJECT;
                }
                double evalCard = this.getCardinality(conf, card, values, context);
                cardinality = evalCard >= 0.0 ? Math.min(cardinality, evalCard) : 0.0;
            } else if (pred != null) {
                double evalCard;
                ArrayList<Value> values = new ArrayList<Value>();
                RdfEvalStatsDAO.CARDINALITY_OF card = RdfEvalStatsDAO.CARDINALITY_OF.PREDICATE;
                values.add((Value)pred);
                if (obj != null) {
                    values.add(obj);
                    card = RdfEvalStatsDAO.CARDINALITY_OF.PREDICATEOBJECT;
                }
                cardinality = (evalCard = this.getCardinality(conf, card, values, context)) >= 0.0 ? Math.min(cardinality, evalCard) : 0.0;
            } else if (obj != null) {
                ArrayList<Value> values = new ArrayList<Value>();
                values.add(obj);
                double evalCard = this.getCardinality(conf, RdfEvalStatsDAO.CARDINALITY_OF.OBJECT, values, context);
                cardinality = evalCard >= 0.0 ? Math.min(cardinality, evalCard) : 0.0;
            } else {
                cardinality = this.getTableSize(conf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (long)cardinality;
    }

    private Value getConstantValue(Var var) {
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    public double getCardinality(RdfCloudTripleStoreConfiguration conf, RdfEvalStatsDAO.CARDINALITY_OF card, List<Value> val) throws RdfDAOException {
        return this.resd.getCardinality(conf, card, val);
    }

    public double getCardinality(RdfCloudTripleStoreConfiguration conf, RdfEvalStatsDAO.CARDINALITY_OF card, List<Value> val, Resource context) throws RdfDAOException {
        return this.resd.getCardinality(conf, card, val, context);
    }

    public int getTableSize(RdfCloudTripleStoreConfiguration conf) throws TableNotFoundException {
        Authorizations authorizations = this.getAuths(conf);
        if (this.joinMap.containsKey("subjectpredicateobject\u0000FullTableCardinality")) {
            this.FullTableCardinality = this.joinMap.get("subjectpredicateobject\u0000FullTableCardinality").intValue();
            return this.FullTableCardinality;
        }
        if (this.FullTableCardinality == 0) {
            Map.Entry entry;
            Scanner joinScanner = this.connector.createScanner(this.tableLayoutStrategy.getSelectivity(), authorizations);
            joinScanner.setRange(Range.prefix((Text)new Text("subjectpredicateobject\u0000FullTableCardinality")));
            Iterator iterator = joinScanner.iterator();
            if (iterator.hasNext() && ((Key)(entry = (Map.Entry)iterator.next()).getKey()).getColumnFamily().toString().equals("FullTableCardinality")) {
                String Count = ((Key)entry.getKey()).getColumnQualifier().toString();
                this.FullTableCardinality = Integer.parseInt(Count);
            }
            if (this.FullTableCardinality == 0) {
                throw new RuntimeException("Table does not contain full cardinality");
            }
        }
        return this.FullTableCardinality;
    }

    private Authorizations getAuths(RdfCloudTripleStoreConfiguration conf) {
        String[] auths = conf.getAuths();
        Authorizations authorizations = null;
        authorizations = auths == null || auths.length == 0 ? new Authorizations() : new Authorizations(auths);
        return authorizations;
    }

    private static class SpExternalCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private List<QueryModelNode> eSet = Lists.newArrayList();

        private SpExternalCollector() {
        }

        public void meetNode(QueryModelNode node) throws RuntimeException {
            if (node instanceof ExternalSet || node instanceof StatementPattern) {
                this.eSet.add(node);
            }
            super.meetNode(node);
        }

        public List<QueryModelNode> getSpExtTup() {
            return this.eSet;
        }
    }
}

