/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.StringUtils;

public final class TimeUtils {
    private static final Logger log = Logger.getLogger(TimeUtils.class);
    public static final String DEFAULT_TIME_SERVER_HOST = "time.nist.gov";
    private static final int NTP_SERVER_TIMEOUT_MS = 15000;

    public static Date getDefaultNtpServerDate() throws IOException {
        return TimeUtils.getNtpServerDate(DEFAULT_TIME_SERVER_HOST);
    }

    public static Date getNtpServerDate(String timeServerHost) throws IOException {
        try {
            TimeInfo timeInfo = null;
            NTPUDPClient timeClient = new NTPUDPClient();
            timeClient.setDefaultTimeout(15000);
            InetAddress inetAddress = InetAddress.getByName(timeServerHost);
            if (inetAddress != null && (timeInfo = timeClient.getTime(inetAddress)) != null) {
                long serverTime = timeInfo.getMessage().getTransmitTimeStamp().getTime();
                Date ntpDate = new Date(serverTime);
                return ntpDate;
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to get NTP server time.", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getRemoteMachineDate(String urlString) throws IOException, ParseException {
        Date remoteDate = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setDoOutput(false);
            conn.setReadTimeout(10000);
            conn.connect();
            Map<String, List<String>> header = conn.getHeaderFields();
            for (String key : header.keySet()) {
                if (key == null || !"Date".equals(key)) continue;
                List<String> data = header.get(key);
                String dateString = data.get(0);
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
                remoteDate = sdf.parse(dateString);
                break;
            }
        }
        finally {
            conn.disconnect();
        }
        return remoteDate;
    }

    public static Long getTimeDifference(Date ntpDate, Date machineDate, boolean isMachineLocal) {
        Long diff = null;
        if (ntpDate != null && machineDate != null) {
            log.info((Object)("NTP Server Time: " + ntpDate));
            String machineLabel = isMachineLocal ? "Local" : "Remote";
            log.info((Object)(machineLabel + " Machine Time: " + machineDate));
            diff = machineDate.getTime() - ntpDate.getTime();
            boolean isAhead = diff > 0L;
            String durationBreakdown = TimeUtils.getDurationBreakdown(diff, false);
            log.info((Object)(machineLabel + " Machine time is " + (isAhead ? "ahead of" : "behind") + " NTP server time by " + durationBreakdown + "."));
        }
        return diff;
    }

    public static Long getNtpServerAndLocalMachineTimeDifference(String timeServerHost) throws IOException {
        log.info((Object)("Getting NTP Server time from " + timeServerHost + "..."));
        Date ntpDate = TimeUtils.getNtpServerDate(timeServerHost);
        Long diff = null;
        if (ntpDate != null) {
            log.info((Object)"Getting Local Machine time...");
            Date machineDate = new Date();
            diff = TimeUtils.getTimeDifference(ntpDate, machineDate, true);
        }
        return diff;
    }

    public static Long getNtpServerAndRemoteMachineTimeDifference(String timeServerHost, String remoteMachineUrlString) throws IOException, ParseException {
        log.info((Object)("Getting NTP Server time from " + timeServerHost + "..."));
        Date ntpDate = TimeUtils.getNtpServerDate(timeServerHost);
        Long diff = null;
        if (ntpDate != null) {
            log.info((Object)("Getting Remote Machine time from " + remoteMachineUrlString + "..."));
            Date machineDate = TimeUtils.getRemoteMachineDate(remoteMachineUrlString);
            diff = TimeUtils.getTimeDifference(ntpDate, machineDate, false);
        }
        return diff;
    }

    public static Long getNtpServerAndMachineTimeDifference(String timeServerHost, String machineUrlString) throws IOException, ParseException {
        boolean isUrlLocalMachine = TimeUtils.isUrlLocalMachine(machineUrlString);
        Long machineTimeOffset = isUrlLocalMachine ? TimeUtils.getNtpServerAndLocalMachineTimeDifference(timeServerHost) : TimeUtils.getNtpServerAndRemoteMachineTimeDifference(timeServerHost, machineUrlString);
        return machineTimeOffset;
    }

    public static Date getMachineDate(String urlString) throws IOException, ParseException {
        boolean isMachineLocal = TimeUtils.isUrlLocalMachine(urlString);
        Date machineDate = isMachineLocal ? new Date() : TimeUtils.getRemoteMachineDate(urlString);
        return machineDate;
    }

    public static boolean isUrlLocalMachine(String urlString) throws UnknownHostException, MalformedURLException {
        String localAddress = InetAddress.getLocalHost().getHostAddress();
        String requestAddress = InetAddress.getByName(new URL(urlString).getHost()).getHostAddress();
        return localAddress != null && requestAddress != null && localAddress.equals(requestAddress);
    }

    public static String getDurationBreakdown(long durationMs) {
        return TimeUtils.getDurationBreakdown(durationMs, true);
    }

    public static String getDurationBreakdown(long durationMs, boolean showSign) {
        long tempDurationMs = Math.abs(durationMs);
        long days = TimeUnit.MILLISECONDS.toDays(tempDurationMs);
        long hours = TimeUnit.MILLISECONDS.toHours(tempDurationMs -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(tempDurationMs -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(tempDurationMs -= TimeUnit.MINUTES.toMillis(minutes));
        long milliseconds = TimeUnit.MILLISECONDS.toMillis(tempDurationMs -= TimeUnit.SECONDS.toMillis(seconds));
        StringBuilder sb = new StringBuilder();
        if (tempDurationMs != 0L && showSign) {
            sb.append(tempDurationMs > 0L ? "+" : "-");
        }
        if (days > 0L) {
            sb.append(days);
            sb.append(days == 1L ? " Day " : " Days ");
        }
        if (hours > 0L) {
            sb.append(hours);
            sb.append(hours == 1L ? " Hour " : " Hours ");
        }
        if (minutes > 0L) {
            sb.append(minutes);
            sb.append(minutes == 1L ? " Minute " : " Minutes ");
        }
        if (seconds > 0L) {
            sb.append(seconds);
            sb.append(seconds == 1L ? " Second " : " Seconds ");
        }
        if (milliseconds > 0L || !showSign && sb.length() == 0 || showSign && sb.length() == 1) {
            sb.append(milliseconds);
            sb.append(milliseconds == 1L ? " Millisecond" : " Milliseconds");
        }
        return StringUtils.trim((String)sb.toString());
    }

    public static boolean dateBeforeInclusive(Date date1, Date date2) {
        return !date1.after(date2);
    }

    public static boolean dateAfterInclusive(Date date1, Date date2) {
        return !date1.before(date2);
    }
}

