/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.mr.merge.util.CopyRule;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.rdftriplestore.RdfCloudTripleStore;
import org.apache.rya.rdftriplestore.inference.InferJoin;
import org.apache.rya.rdftriplestore.inference.InferUnion;
import org.apache.rya.rdftriplestore.inference.InferenceEngine;
import org.apache.rya.rdftriplestore.inference.InverseOfVisitor;
import org.apache.rya.rdftriplestore.inference.SameAsVisitor;
import org.apache.rya.rdftriplestore.inference.SubClassOfVisitor;
import org.apache.rya.rdftriplestore.inference.SubPropertyOfVisitor;
import org.apache.rya.rdftriplestore.inference.SymmetricPropertyVisitor;
import org.apache.rya.rdftriplestore.inference.TransitivePropertyVisitor;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.apache.rya.rdftriplestore.utils.TransitivePropertySP;
import org.apache.rya.sail.config.RyaSailFactory;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.ListMemberOperator;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.SailException;

public class QueryRuleset {
    private static final Logger log = Logger.getLogger(QueryRuleset.class);
    protected Set<CopyRule> rules = new HashSet<CopyRule>();
    protected String query;
    protected RdfCloudTripleStoreConfiguration conf;

    public QueryRuleset(RdfCloudTripleStoreConfiguration conf) throws QueryRulesetException {
        this.conf = conf;
        this.setQuery();
        this.setRules();
    }

    public QueryRuleset(String query) throws QueryRulesetException {
        this.query = query;
        this.setRules();
    }

    public String getQuery() {
        return this.query;
    }

    private void setQuery() throws QueryRulesetException {
        if (this.conf == null) {
            throw new QueryRulesetException("No Configuration given");
        }
        this.query = this.conf.get("ac.copy.query");
        String queryFile = this.conf.get("ac.copy.queryfile");
        if (this.query == null && queryFile != null) {
            try {
                FileReader fileReader = new FileReader(queryFile);
                BufferedReader reader = new BufferedReader(fileReader);
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line).append("\n");
                    line = reader.readLine();
                }
                this.query = builder.toString();
                reader.close();
                this.conf.set("ac.copy.query", this.query);
            }
            catch (IOException e) {
                throw new QueryRulesetException("Error loading query from file: " + queryFile, e);
            }
        } else if (this.query == null) {
            throw new QueryRulesetException("No query string or query file provided");
        }
    }

    private void setRules() throws QueryRulesetException {
        ParsedTupleQuery ptq;
        try {
            ptq = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)this.query, null);
        }
        catch (MalformedQueryException | UnsupportedQueryLanguageException e) {
            throw new QueryRulesetException("Error parsing query:\n" + this.query, e);
        }
        final TupleExpr te = ptq.getTupleExpr();
        te.visit((QueryModelVisitor)new QueryModelVisitorBase<QueryRulesetException>(){

            public void meet(StatementPattern node) throws QueryRulesetException {
                if (!(node.getSubjectVar().hasValue() || node.getPredicateVar().hasValue() || node.getObjectVar().hasValue())) {
                    throw new QueryRulesetException("Statement pattern with no constants would match every statement:\n" + node + "\nFrom parsed query:\n" + te);
                }
            }
        });
        if (this.conf != null && this.conf.isInfer().booleanValue()) {
            RdfCloudTripleStore store = null;
            try {
                log.info((Object)"Applying inference rules");
                store = (RdfCloudTripleStore)RyaSailFactory.getInstance((Configuration)this.conf);
                InferenceEngine inferenceEngine = store.getInferenceEngine();
                te.visit((QueryModelVisitor)new TransitivePropertyVisitor(this.conf, inferenceEngine));
                te.visit((QueryModelVisitor)new SymmetricPropertyVisitor(this.conf, inferenceEngine));
                te.visit((QueryModelVisitor)new InverseOfVisitor(this.conf, inferenceEngine));
                te.visit((QueryModelVisitor)new SubPropertyOfVisitor(this.conf, inferenceEngine));
                te.visit((QueryModelVisitor)new SubClassOfVisitor(this.conf, inferenceEngine));
                te.visit((QueryModelVisitor)new SameAsVisitor(this.conf, inferenceEngine));
                log.info((Object)"Query after inference:\n");
                for (String line : te.toString().split("\n")) {
                    log.info((Object)("\t" + line));
                }
            }
            catch (Exception e) {
                throw new QueryRulesetException("Error applying inference to parsed query:\n" + te, e);
            }
            finally {
                if (store != null) {
                    try {
                        store.shutDown();
                    }
                    catch (SailException e) {
                        log.error((Object)"Error shutting down Sail after applying inference", (Throwable)e);
                    }
                }
            }
        }
        RulesetVisitor rv = new RulesetVisitor();
        try {
            te.visit((QueryModelVisitor)rv);
            rv.addSchema();
        }
        catch (QueryRulesetException e) {
            throw new QueryRulesetException("Error extracting rules from parsed query:\n" + te, e);
        }
        for (CopyRule candidateRule : rv.rules) {
            boolean unique = true;
            for (CopyRule otherRule : rv.rules) {
                if (candidateRule.equals((Object)otherRule) || !otherRule.isGeneralizationOf(candidateRule)) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            this.rules.add(candidateRule);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Original Query:\n\n\t");
        sb.append(this.query.replace("\n", "\n\t")).append("\n\nRuleset:\n");
        for (CopyRule rule : this.rules) {
            sb.append("\n\t").append(rule.toString().replace("\n", "\n\t")).append("\n");
        }
        return sb.toString();
    }

    private static class RulesetVisitor
    extends QueryModelVisitorBase<QueryRulesetException> {
        List<CopyRule> rules = new LinkedList<CopyRule>();
        private final Set<Value> superclasses = new HashSet<Value>();
        private final Set<Value> superproperties = new HashSet<Value>();
        private final Set<Value> sameAs = new HashSet<Value>();
        private final Set<Value> transitive = new HashSet<Value>();
        private final Set<Value> schemaProperties = new HashSet<Value>();

        private RulesetVisitor() {
        }

        public void meet(StatementPattern node) throws QueryRulesetException {
            Var predVar = node.getPredicateVar();
            if (node instanceof TransitivePropertySP && predVar.hasValue()) {
                node = new StatementPattern(new Var("transitiveSubject"), predVar, new Var("transitiveObject"), node.getContextVar());
                this.transitive.add(predVar.getValue());
            }
            this.rules.add(new CopyRule(node));
        }

        public void meet(Filter node) throws QueryRulesetException {
            ValueExpr condition = node.getCondition();
            if (condition instanceof FunctionCall) {
                String uri = ((FunctionCall)condition).getURI();
                if (FunctionRegistry.getInstance().get((Object)uri) == null) {
                    node.getArg().visit((QueryModelVisitor)this);
                }
            } else {
                RulesetVisitor childVisitor = new RulesetVisitor();
                node.getArg().visit((QueryModelVisitor)childVisitor);
                for (CopyRule rule : childVisitor.rules) {
                    rule.addCondition(condition);
                    this.rules.add(rule);
                }
                this.superclasses.addAll(childVisitor.superclasses);
                this.superproperties.addAll(childVisitor.superproperties);
            }
        }

        public void meet(Join node) throws QueryRulesetException {
            TupleExpr left = node.getLeftArg();
            TupleExpr right = node.getRightArg();
            if (node instanceof InferJoin && left instanceof FixedStatementPattern) {
                StatementPattern dne;
                FixedStatementPattern fsp = (FixedStatementPattern)left;
                Value predValue = fsp.getPredicateVar().getValue();
                if (RDFS.SUBCLASSOF.equals((Object)predValue) && right instanceof StatementPattern) {
                    dne = (StatementPattern)right;
                    for (Statement st : fsp.statements) {
                        Resource superclassVal = st.getSubject();
                        this.rules.add(new CopyRule(new StatementPattern(dne.getSubjectVar(), dne.getPredicateVar(), new Var(superclassVal.toString(), (Value)superclassVal), dne.getContextVar())));
                        this.superclasses.add((Value)superclassVal);
                    }
                } else if (RDFS.SUBPROPERTYOF.equals((Object)predValue) && right instanceof StatementPattern) {
                    dne = (StatementPattern)right;
                    for (Statement st : fsp.statements) {
                        Resource superpropVal = st.getSubject();
                        this.rules.add(new CopyRule(new StatementPattern(dne.getSubjectVar(), new Var(superpropVal.toString(), (Value)superpropVal), dne.getObjectVar(), dne.getContextVar())));
                        this.superproperties.add((Value)superpropVal);
                    }
                }
                if (OWL.SAMEAS.equals((Object)predValue)) {
                    InferJoin inner;
                    StatementPattern stmt = null;
                    String replaceVar = fsp.getSubjectVar().getName();
                    String replaceVarInner = null;
                    LinkedList<Resource> replacements = new LinkedList<Resource>();
                    LinkedList<Resource> replacementsInner = new LinkedList<Resource>();
                    for (Statement statement : fsp.statements) {
                        replacements.add(statement.getSubject());
                    }
                    if (right instanceof StatementPattern) {
                        stmt = (StatementPattern)right;
                    } else if (right instanceof InferJoin && (inner = (InferJoin)right).getLeftArg() instanceof FixedStatementPattern && inner.getRightArg() instanceof StatementPattern) {
                        stmt = (StatementPattern)inner.getRightArg();
                        fsp = (FixedStatementPattern)inner.getLeftArg();
                        replaceVarInner = fsp.getSubjectVar().getName();
                        for (Statement st : fsp.statements) {
                            replacementsInner.add(st.getSubject());
                        }
                    }
                    if (stmt != null) {
                        for (Value value : replacements) {
                            if (replacementsInner.isEmpty()) {
                                StatementPattern transformed = stmt.clone();
                                if (transformed.getSubjectVar().equals((Object)replaceVar)) {
                                    transformed.setSubjectVar(new Var(replaceVar, value));
                                }
                                if (transformed.getObjectVar().equals((Object)replaceVar)) {
                                    transformed.setObjectVar(new Var(replaceVar, value));
                                }
                                this.rules.add(new CopyRule(transformed));
                            }
                            for (Value value2 : replacementsInner) {
                                StatementPattern transformed = stmt.clone();
                                if (transformed.getSubjectVar().equals((Object)replaceVar)) {
                                    transformed.setSubjectVar(new Var(replaceVar, value));
                                } else if (transformed.getSubjectVar().equals((Object)replaceVarInner)) {
                                    transformed.setSubjectVar(new Var(replaceVarInner, value2));
                                }
                                if (transformed.getObjectVar().equals((Object)replaceVar)) {
                                    transformed.setObjectVar(new Var(replaceVar, value));
                                } else if (transformed.getObjectVar().equals((Object)replaceVarInner)) {
                                    transformed.setObjectVar(new Var(replaceVar, value2));
                                }
                                this.rules.add(new CopyRule(transformed));
                            }
                        }
                    }
                    this.sameAs.addAll(replacements);
                    this.sameAs.addAll(replacementsInner);
                }
            } else {
                super.meet(node);
            }
        }

        public void meet(Union node) throws QueryRulesetException {
            node.visitChildren((QueryModelVisitor)this);
            if (node instanceof InferUnion) {
                QueryModelVisitorBase<QueryRulesetException> propertyVisitor = new QueryModelVisitorBase<QueryRulesetException>(){

                    public void meet(StatementPattern node) {
                        if (node.getPredicateVar().hasValue()) {
                            URI predValue = (URI)node.getPredicateVar().getValue();
                            String ns = predValue.getNamespace();
                            if (node instanceof FixedStatementPattern && (RDFS.SUBPROPERTYOF.equals((Object)predValue) || OWL.EQUIVALENTPROPERTY.equals((Object)predValue))) {
                                FixedStatementPattern fsp = (FixedStatementPattern)node;
                                for (Statement stmt : fsp.statements) {
                                    schemaProperties.add(stmt.getSubject());
                                }
                            } else if (!("http://www.w3.org/2002/07/owl#".equals(ns) || "http://www.w3.org/2000/01/rdf-schema#".equals(ns) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(ns))) {
                                schemaProperties.add(predValue);
                            }
                        }
                    }
                };
                node.getLeftArg().visit((QueryModelVisitor)propertyVisitor);
                node.getRightArg().visit((QueryModelVisitor)propertyVisitor);
            }
        }

        public void addSchema() throws QueryRulesetException {
            if (!this.superclasses.isEmpty()) {
                Var superClassVar = new Var("superClassVar");
                this.addListRule(new Var("subClassVar"), null, RDFS.SUBCLASSOF, superClassVar, this.superclasses);
                this.addListRule(new Var("eqClassSubject"), this.superclasses, OWL.EQUIVALENTCLASS, new Var("eqClassObject"), this.superclasses);
            }
            if (!this.superproperties.isEmpty()) {
                Var superPropertyVar = new Var("superPropertyVar");
                this.addListRule(new Var("subPropertyVar"), null, RDFS.SUBPROPERTYOF, superPropertyVar, this.superproperties);
                this.addListRule(new Var("eqPropSubject"), this.superproperties, OWL.EQUIVALENTPROPERTY, new Var("eqPropObject"), this.superproperties);
            }
            if (!this.sameAs.isEmpty()) {
                Var sameAsSubj = new Var("sameAsSubject");
                Var sameAsObj = new Var("sameAsObject");
                this.addListRule(sameAsSubj, this.sameAs, OWL.SAMEAS, sameAsObj, this.sameAs);
            }
            if (!this.transitive.isEmpty()) {
                Var transitiveVar = new Var(OWL.TRANSITIVEPROPERTY.toString(), (Value)OWL.TRANSITIVEPROPERTY);
                this.addListRule(new Var("transitiveProp"), this.transitive, RDF.TYPE, transitiveVar, null);
            }
            if (!this.schemaProperties.isEmpty()) {
                Var symmetricVar = new Var(OWL.SYMMETRICPROPERTY.toString(), (Value)OWL.SYMMETRICPROPERTY);
                this.addListRule(new Var("symmetricProp"), this.schemaProperties, RDF.TYPE, symmetricVar, null);
                this.addListRule(new Var("inverseSubject"), this.schemaProperties, OWL.INVERSEOF, new Var("inverseObject"), this.schemaProperties);
            }
        }

        private void addListRule(Var subjVar, Set<Value> subjValues, URI predicate, Var objVar, Set<Value> objValues) throws QueryRulesetException {
            ListMemberOperator subjCondition = null;
            ListMemberOperator objCondition = null;
            if (subjValues != null) {
                subjCondition = new ListMemberOperator();
                subjCondition.addArgument((ValueExpr)subjVar);
                for (Value constant : subjValues) {
                    subjCondition.addArgument((ValueExpr)new Var(constant.toString(), constant));
                }
            }
            if (objValues != null) {
                objCondition = new ListMemberOperator();
                objCondition.addArgument((ValueExpr)objVar);
                for (Value constant : objValues) {
                    objCondition.addArgument((ValueExpr)new Var(constant.toString(), constant));
                }
            }
            Var predVar = new Var(predicate.toString(), (Value)predicate);
            CopyRule listRule = new CopyRule(new StatementPattern(subjVar, predVar, objVar));
            if (subjCondition != null && objCondition != null) {
                listRule.addCondition((ValueExpr)new Or((ValueExpr)subjCondition, (ValueExpr)objCondition));
            } else if (subjCondition != null) {
                listRule.addCondition((ValueExpr)subjCondition);
            } else if (objCondition != null) {
                listRule.addCondition((ValueExpr)objCondition);
            }
            this.rules.add(listRule);
        }
    }

    public static class QueryRulesetException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public QueryRulesetException(String s) {
            super(s);
        }

        public QueryRulesetException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

