/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class GroupedRow
implements WritableComparable<GroupedRow> {
    private final Text group = new Text();
    private Key key = new Key();
    private Value value = new Value();

    public void setGroup(String name) {
        this.group.set(name);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Text getGroup() {
        return this.group;
    }

    public Key getKey() {
        return this.key;
    }

    public Value getValue() {
        return this.value;
    }

    public void write(DataOutput out) throws IOException {
        this.group.write(out);
        this.key.write(out);
        this.value.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.group.readFields(in);
        this.key.readFields(in);
        this.value.readFields(in);
    }

    public int compareTo(GroupedRow o) {
        if (o == null) {
            return 1;
        }
        return new CompareToBuilder().append((Object)this.group, (Object)o.group).append((Object)this.key, (Object)o.key).append((Object)this.value, (Object)o.value).toComparison();
    }

    public int hashCode() {
        return Objects.hash(this.group, this.key, this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof GroupedRow) {
            GroupedRow other = (GroupedRow)o;
            return new EqualsBuilder().append((Object)this.group, (Object)other.group).append((Object)this.key, (Object)other.key).append((Object)this.value, (Object)other.value).isEquals();
        }
        return false;
    }

    public static class GroupComparator
    extends WritableComparator {
        GroupComparator() {
            super(GroupedRow.class, true);
        }

        public int compare(WritableComparable wc1, WritableComparable wc2) {
            GroupedRow gk1 = (GroupedRow)wc1;
            GroupedRow gk2 = (GroupedRow)wc2;
            return gk1.group.compareTo((BinaryComparable)gk2.group);
        }
    }

    public static class SortComparator
    extends WritableComparator {
        SortComparator() {
            super(GroupedRow.class, true);
        }

        public int compare(WritableComparable wc1, WritableComparable wc2) {
            GroupedRow gk1 = (GroupedRow)wc1;
            GroupedRow gk2 = (GroupedRow)wc2;
            return gk1.compareTo(gk2);
        }
    }
}

